package ch.rolfp.sonnenpos

import android.Manifest.permission.ACCESS_FINE_LOCATION
import android.annotation.SuppressLint
import android.content.pm.PackageManager
import android.location.Location
import android.os.Bundle
import android.text.InputType
import android.widget.AdapterView
import android.widget.ArrayAdapter
import android.widget.EditText
import android.widget.ListView
import android.widget.Toast
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import ch.rolfp.sonnenpos.orte.Ort
import ch.rolfp.sonnenpos.orte.inListeSuchen
import ch.rolfp.sonnenpos.databinding.ActivityMainBinding
import com.google.android.gms.location.FusedLocationProviderClient
import com.google.android.gms.location.LocationServices
import com.google.android.material.floatingactionbutton.FloatingActionButton
import java.util.GregorianCalendar
import kotlin.math.asin
import kotlin.math.atan
import kotlin.math.atan2
import kotlin.math.cos
import kotlin.math.floor
import kotlin.math.sin
import kotlin.math.tan

var Fehler:Int = 0//test
var zeiteingabe:String = "12:00:00"
var datumeingabe:String = "25.8.2025"
var position:String = "47.365 N  8.622 E"
var ortsname:String = ""
var jahrvorher:Int = 1
var monatvorher:Int = 1

class MainActivity : AppCompatActivity() {
    val MIN_TIME_TO_REFRESH: Long = 3000L
    val MIN_DISTANCE_TO_REFRESH: Float = 0F
    private lateinit var fusedLocationProviderClient: FusedLocationProviderClient
    lateinit var datumzeit: GregorianCalendar
    private lateinit var binding: ActivityMainBinding
    private lateinit var lvTodoList: ListView
    private lateinit var fab: FloatingActionButton
    private lateinit var fab2: FloatingActionButton
    private lateinit var fab3: FloatingActionButton
    private lateinit var shoppingItems: ArrayList<String>
    private lateinit var itemAdapter: ArrayAdapter<String>
    private var zeitzone:Int = 0 //0=UTC 1=MEZ 2=MESZ
    fun calcZeitDatum(datumzeit:GregorianCalendar):Unit {
        var string ="";
        var jahr:Int; var monat:Int; var tag:Int; var stunde:Int; var minute:Int; var sekunde:Int
        jahr = datumzeit.get(GregorianCalendar.YEAR); jahrvorher=jahr
        monat = datumzeit.get(GregorianCalendar.MONTH)+1; monatvorher=monat
        tag = datumzeit.get(GregorianCalendar.DAY_OF_MONTH);
        stunde = datumzeit.get(GregorianCalendar.HOUR_OF_DAY)
        minute = datumzeit.get(GregorianCalendar.MINUTE)
        sekunde = datumzeit.get(GregorianCalendar.SECOND)
        zeitzone = datumzeit.get(GregorianCalendar.ZONE_OFFSET)/(60*60*1000)
        zeitzone += datumzeit.get(GregorianCalendar.DST_OFFSET)/(60*60*1000) //Sommerzeit beruecksichtigen
        //TODO: testen ob Sommerzeit richtig erkannt
        if(zeitzone>23) zeitzone=23; else if(zeitzone< -23) zeitzone= -23 //test
        zeiteingabe = sprintzeit(stunde,minute,sekunde)
        if(zeitzone==1) zeiteingabe += " MEZ"
        else if(zeitzone==2) zeiteingabe += " MESZ"
        else if(zeitzone>0) zeiteingabe += "+$zeitzone"
        else if(zeitzone<0) zeiteingabe += "$zeitzone"
        else zeiteingabe += " UTC"
        datumeingabe = sprintdatum(tag,monat,jahr)
    }

    fun erneuern():Unit {
        val resultat=berechnung(position, datumeingabe, zeiteingabe, zeitzone)
        if(ortsname!="") shoppingItems.set(0,position+"\n$ortsname")
        else shoppingItems.set(0,position)
        shoppingItems.set(1,datumeingabe)
        shoppingItems.set(2,zeiteingabe)
        shoppingItems.set(3,resultat[1]) //Sonnenaufgang
        shoppingItems.set(4,resultat[2]) //Sonnenuntergang
        shoppingItems.set(5,resultat[3]) //Hoechststand

        val maxa:Int = 5 //maximale Anzahl anzuzeigende Resultate
        if(shoppingItems.size<=5+maxa) shoppingItems.add(resultat[0])
        else shoppingItems.set(5+maxa,resultat[0])
        itemAdapter.notifyDataSetChanged()
    }

    private fun requestPermission() {
        ActivityCompat.requestPermissions(this,
            arrayOf(android.Manifest.permission.ACCESS_COARSE_LOCATION, android.Manifest.permission.ACCESS_FINE_LOCATION),
            PERMISSION_REQUEST_ACCESS_LOCATION)
    }
    companion object{private const val PERMISSION_REQUEST_ACCESS_LOCATION=100}

    @SuppressLint("MissingPermission")
    private fun getCurrentLocation() {
        fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient(this)
        fusedLocationProviderClient.lastLocation.addOnCompleteListener(this) { task->
            val location: Location? = task.result
            if(location==null) {
                Toast.makeText(applicationContext, "Null Recieved", Toast.LENGTH_SHORT).show()
            } else {
                var breite = location.getLatitude();
                var laenge = location.getLongitude();
                if(breite>=0.0 && laenge>=0.0) position = "$breite N  $laenge E"
                else if(breite<0.0 && laenge>=0.0) {breite = -breite; position = "$breite S  $laenge E"}
                else if(breite>=0.0 && laenge<0.0) {laenge = -laenge; position = "$breite N  $laenge W"}
                else {breite = -breite; laenge = -laenge; position = "$breite S  $laenge W"}
                //Toast.makeText(applicationContext, "position=$position", Toast.LENGTH_SHORT).show()//test
                ortsname=""
                erneuern()
            }
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        datumzeit = GregorianCalendar()
        calcZeitDatum(datumzeit)

        lvTodoList = findViewById(R.id.lvTodoList)
        fab = findViewById(R.id.floatingActionButton)
        fab2 = findViewById(R.id.floatingActionButton2)
        fab3 = findViewById(R.id.floatingActionButton3)
        shoppingItems = ArrayList()

        shoppingItems.add(position)
        shoppingItems.add(datumeingabe)
        shoppingItems.add(zeiteingabe)
        shoppingItems.add("Sonnenaufgang")
        shoppingItems.add("Sonnenuntergang")
        shoppingItems.add("Hoechststand")

        itemAdapter = ArrayAdapter(this, android.R.layout.simple_list_item_1, shoppingItems)
        lvTodoList.adapter = itemAdapter

        erneuern()

        lvTodoList.onItemLongClickListener = AdapterView.OnItemLongClickListener { arg0, arg1, pos, id ->
            if(pos>=6) {
                shoppingItems.removeAt(pos)
                itemAdapter.notifyDataSetChanged()
                Toast.makeText(applicationContext, "Element gelöscht", Toast.LENGTH_SHORT).show()
            }
            true
        }

        lvTodoList.onItemClickListener = AdapterView.OnItemClickListener { arg0, arg1, pos, id ->
            if(pos==1 || pos==2) {
                datumzeit = GregorianCalendar()
                calcZeitDatum(datumzeit)
                //itemAdapter.notifyDataSetChanged()
                erneuern()
                Toast.makeText(applicationContext, "Zeit/Datum aktualisiert", Toast.LENGTH_SHORT).show()
            }
            else if(pos==0) {
                if(ContextCompat.checkSelfPermission(this,ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED) {
                    //Toast.makeText(applicationContext,"Permission erhalten",Toast.LENGTH_SHORT).show()//test
                    getCurrentLocation()
                } else {
                    requestPermission() //Benutzer nach Berechtigung fragen
                }
            }
            true
        }

        fab.setOnClickListener {
            var builder = AlertDialog.Builder(this)
            builder.setTitle("Datum eingeben")
            var input = EditText(this)
            input.hint = "24.08.2025"
            input.inputType = InputType.TYPE_DATETIME_VARIATION_DATE
            builder.setView(input)
            builder.setPositiveButton("OK") { dialog, which ->
                val eingabe:String = input.text.toString()
                if(checkDatumSyntax(eingabe)) datumeingabe=eingabe
                else Toast.makeText(applicationContext,"falsche Datumeingabe",Toast.LENGTH_SHORT).show()
                erneuern()
            }
            builder.setNegativeButton("Abbrechen") {dialog, which ->
                Toast.makeText(applicationContext,"abgebrochen",Toast.LENGTH_SHORT).show()
            }
            builder.show()
        }

        fab2.setOnClickListener {
            var builder = AlertDialog.Builder(this)
            builder.setTitle("Zeit eingeben")
            var input = EditText(this)
            input.hint = "12:30:00"
            input.inputType = InputType.TYPE_CLASS_TEXT
            builder.setView(input)
            builder.setPositiveButton("OK") { dialog, which ->
                //if(input.text.isEmpty()) {zeiteingabe="00:00:00"}
                if(input.text.isEmpty() || input.text.length < 2) {
                    datumzeit = GregorianCalendar() //aktuelle Zeit
                    calcZeitDatum(datumzeit)
                } else {
                    val eingabe:String = input.text.toString()
                    if(checkZeitSyntax(eingabe)) zeiteingabe=eingabe
                    else Toast.makeText(applicationContext,"falsche Zeiteingabe",Toast.LENGTH_SHORT).show()
                    zeitzone = getZeitzone(zeiteingabe,zeitzone)
                    if(Fehler!=0) {
                        Toast.makeText(applicationContext,"Fehler$Fehler",Toast.LENGTH_LONG).show()
                        Fehler=0;
                    } else {
                        Toast.makeText(applicationContext,"zeitzone=$zeitzone",Toast.LENGTH_LONG).show()
                    }//test
                }
                erneuern()
            }
            builder.setNegativeButton("Abbrechen") {dialog, which ->
                Toast.makeText(applicationContext,"abgebrochen",Toast.LENGTH_SHORT).show()
            }
            builder.show()
        }

        fab3.setOnClickListener {
            var builder = AlertDialog.Builder(this)
            builder.setTitle("Pos: 47.365 N  8.622 E")
            var input = EditText(this)
            input.hint = "47.365 N  8.622 E"
            input.inputType = InputType.TYPE_CLASS_TEXT
            builder.setView(input)
            builder.setPositiveButton("OK") { dialog, which ->
                if(input.text.isNotEmpty()) {
                    var posneu:String = input.text.toString()
                    if(checkPositionSyntax(posneu)==true) {
                        position=posneu.uppercase()
                        ortsname=""
                    } else {
                        val ort:Ort? = inListeSuchen(posneu)
                        if(ort!=null) {
                            var lat=ort.lat; var lon=ort.lon
                            var NS:Char = 'N'; var EW: Char = 'E'
                            if(lat<0) {NS='S'; lat = -lat}
                            if(lon<0) {EW='W'; lon = -lon}
                            var name = ort.ort
			                if(ort.land!=null && ort.land!=ort.ort) name += " ("+ort.land+")";
                            position = "$lat $NS  $lon $EW"
                            ortsname = name;
                        } else Toast.makeText(applicationContext,"Ort \"$posneu\" nicht gefunden",Toast.LENGTH_LONG).show()
                    }
                }
                erneuern()
            }
            builder.setNegativeButton("Abbrechen") {dialog, which ->
                Toast.makeText(applicationContext,"abgebrochen",Toast.LENGTH_SHORT).show()
            }
            builder.show()
        }

    }
}

fun checkPositionSyntax(position:String): Boolean {
    if(position.isEmpty() || position.length < 4) return false
    var posu = position.uppercase()
    if(posu[0] >= '0' && posu[0] <= '9') {
        if(posu.contains('N') && posu.contains('E')) return true;
        if(posu.contains('N') && posu.contains('W')) return true;
        if(posu.contains('S') && posu.contains('E')) return true;
        if(posu.contains('S') && posu.contains('W')) return true;
    }
    return false
}

fun checkDatumSyntax(str:String): Boolean {
    if(str.isEmpty() || !(str[0]>='0' && str[0]<='9')) return false
    if(str.contains(':')) return false
    return true
}

fun checkZeitSyntax(str:String): Boolean {
    if(str.isEmpty() || !(str[0]>='0' && str[0]<='9')) return false
    if(str.contains('.') || str.contains('-')) return false
    return true
}

fun getZeitzone(zeit:String, zeitzone:Int):Int {
    var zone:Int = zeitzone
    val str = zeit.uppercase()
    if(str.contains('M'))
      {if(str.contains('S')) zone = 2; else zone = 1}
    else if(str.contains('U')) zone = 0
    return zone
}

fun berechnung(position:String, datum:String, zeit:String, zeitzone:Int): Array<String> {
    var haz:hoeheAzimut
    var refraktflag:Int = 1
    var tag:Int; var monat:Int; var jahr: Int
    var stunde:Int; var min:Int; var sek: Int
    var z=mysscanf(datum); tag=z[0]; monat=z[1]; jahr=z[2];
    if(jahr<100 || monat>12 || monat<1 ) {
        if(jahr==0) jahr=jahrvorher; else if(jahr<100) jahr+=2000;
        if(monat>12) monat=12; else if(monat<1) monat=monatvorher;
        datumeingabe=sprintdatum(tag,monat,jahr)
    }
    if(monat>12) monat=12; else if(monat<1) monat=1

    z = mysscanf(zeit); stunde=z[0]; min=z[1]; sek=z[2];
    if(stunde>23) stunde=23; if(min>59) min=59; if(sek>59) sek=59
    zeiteingabe = sprintzeit(stunde,min,sek)
    if(zeitzone==1) zeiteingabe += " MEZ"
    else if(zeitzone==2) zeiteingabe += " MESZ"
    else if(zeitzone>0) zeiteingabe += "+$zeitzone"
    else if(zeitzone<0) zeiteingabe += "$zeitzone"
    else zeiteingabe += " UTC"
    val lat:Double //Geografische Breite
    val lon:Double //Geografische Laenge
    val p=getLatLon(position); lat=p[0]; lon=p[1]
    haz = sonnenposition_berechnen(jahr,monat,tag,stunde,min,sek,lat,lon,zeitzone,refraktflag)
    val hoehe=haz.hoehe; val azimut=haz.azimut;
    val hoeheGrad = runden(hoehe/GRAD,2)
    val azimutGrad = runden(azimut/GRAD,2)
    //val resultat="Hoehe=$hoeheGrad Grad  Azimut=$azimutGrad Grad"
    val resultat = sprintzeit(stunde,min,sek) + "  Höhe=$hoeheGrad° Azimut=$azimutGrad°"
    var maxhoehe:Double = -90*GRAD; var hoehevorher=maxhoehe
    stunde=0; min=0; sek=0; //refraktflag=0;
    var maxstu:Int=0; var maxmin:Int=0; var maxsek:Int=0;
    var aufgang:String="--"; var untergang:String="--"; var hoechststand:String="--"
    while(stunde<24) {
        haz = sonnenposition_berechnen(jahr,monat,tag,stunde,min,sek,lat,lon,zeitzone,refraktflag)
        val hoehe=haz.hoehe; val azimut=haz.azimut;
        if(hoehe>=0 && hoehevorher<0) aufgang=sprintzeit(stunde,min,sek)
        else if(hoehe<0 && hoehevorher>=0) untergang=sprintzeit(stunde,min,sek)
        if(hoehe>maxhoehe) {maxhoehe=hoehe; maxstu=stunde; maxmin=min; maxsek=sek}
        hoehevorher=hoehe
        if(++sek==60) {sek=0; if(++min==60) {min=0; ++stunde}}
    }
    var maxhoeheGrad = runden(maxhoehe/GRAD,2)
    hoechststand = "Höchststand: $maxhoeheGrad° um " + sprintzeit(maxstu,maxmin,maxsek)
    return arrayOf(resultat,"Sonnenaufgang: $aufgang","Sonnenuntergang: $untergang",hoechststand)
}

fun getLatLon(position:String):Array<Double> {
    var breite:Double = 0.0 //positiv: noerdlich, negativ: suedlich
    var laenge:Double = 0.0 //positiv: oestlich, negativ: westlich
    val str = position.uppercase()
    //str = "47.512 N 8.503 E"
    var parts: List<String> = arrayOf("").toList()
    var fehler:Int = 0
    if(str.isEmpty() || !str[0].isDigit()) {
        fehler=13;
    } else if(str.contains('N')) {
        parts = str.split("N")
        breite = parts[0].toDouble()
    } else if(str.contains('S')) {
        parts = str.split("S")
        breite = -parts[0].toDouble()
    } else {fehler=11; parts = str.split("")}
    if(fehler==0) {
        if(parts[1].contains('E')) {
            val parts2 = parts[1].split("E")
            laenge = parts2[0].toDouble()
        } else if(parts[1].contains('W')) {
            val parts2 = parts[1].split("W")
            laenge = -parts2[0].toDouble()
    }
    else fehler=12
    }
    if(fehler!=0) Fehler=fehler;
    return arrayOf(breite,laenge)
}

fun runden(x:Double, n:Int):Double { //x auf n Nachkommastellen runden
 if(x<0.0) return -runden(-x,n)
 var z:Int=1
 var k:Int=n
 while(k>0) {z*=10; k--}
 return floor(x*z+0.5)/z
}

fun sprintzeit(h:Int, m:Int, s:Int):String {
    var str: String = ""
    if(h<10) str+="0"
    str+="$h:"; if(m<10) str+="0"
    str+="$m:"; if(s<10) str+="0"
    str+="$s"
    return str
}

fun sprintdatum(tag:Int, mon:Int, year:Int):String {
    val str:String
    if(tag<10) str = " $tag.$mon.$year"
    else       str = "$tag.$mon.$year"
    return str
}

fun sprintAufUnter(text1:String, stu:Int, min:Int, sek:Int, azimutGrad:Double):String
{// Beispiel: "Sonnenaufgang: 6:30:05  Azimut: 100.35 Grad"
 var str:String = text1
 str += sprintzeit(stu,min,sek);
 str += "  Azimut: $azimutGrad Grad"
 return str
}

fun mysscanf(eingabe:String):Array<Int> {
    if(eingabe.isEmpty()) return arrayOf(0,0,0)
    val parts = eingabe.split(':','.',' ','U','M')
    if(parts.isEmpty() || parts[0].isEmpty()) return arrayOf(0,0,0)
    val p1:Int = parts[0].toInt()
    var p2:Int; if(parts.size>1 && !parts[1].isEmpty()) p2 = parts[1].toInt(); else p2=0
    var p3:Int; if(parts.size>2 && !parts[2].isEmpty()) p3 = parts[2].toInt(); else p3=0
    return arrayOf(p1,p2,p3)
}

val PI:Double = (atan(1.0)*4.0)
val ZWEIPI:Double = 2.0*PI
val GRAD:Double = PI/180.0
val WINKELMINUTE:Double = GRAD/60.0

var monatstage = arrayOf(0,31,28,31,30,31,30,31,31,30,31,30,31)
class jahrMonatTagStunde(val jahr:Int,val monat:Int,val tag:Int,val stunde:Int)
data class hoeheAzimut(val hoehe:Double, val azimut:Double)

/************** Formel zum Sonnenposition berechnen *******************/
// JD-Formel: http://www.chem.uzh.ch/pfister/formelsammlung.html#mjd
// weitere Formeln: https://de.wikipedia.org/wiki/Sonnenstand

fun MJD(jahr:Int, monat:Int, tag:Int, stunde:Int, minute:Int, sekunde:Int):Double //Zeit in UT
{
 var y:Int; var m:Int; var B:Int; var d:Int=tag
 val h:Double = stunde+minute/60.0+sekunde/3600.0
 if(monat<=2) {y=jahr-1; m=monat+13;}
 else         {y=jahr;   m=monat+1;}
 if(y<1582 || (y==1582 && (monat<10 || (monat==10 && tag<=4))))
       {B = (y+4716)/4-1181} //bis 4.Okt.1582
 else  {B = y/400-y/100+y/4} //ab 15.Okt.1582
 return 365.0*y-679004+B+floor(30.6*m)+d+h/24.0;
}

fun sonnenposition_berechnen(jahr1:Int, monat1:Int, tag1:Int, //Datum und
			     stunde1:Int, minute:Int, sekunde:Int, //Zeit in UT oder MEZ oder MESZ
			     lat:Double, lon:Double, //Geographische Koordinaten in Grad
			     zeitzone:Int, //0=UT, 1=MEZ, 2=MESZ
			     refraktflag:Int //1 = Refraktion beruecksichtigen
			     ):hoeheAzimut //Rueckgabewerte in Rad
{
 var jahr:Int; var monat:Int; var tag:Int; var stunde:Int
 if(zeitzone!=0)
  {//Umrechnung der Zeit in UT
   val zeit1:jahrMonatTagStunde = jahrMonatTagStunde(jahr1, monat1, tag1, stunde1)
   val zeit = umrechnung_zonenzeit_nach_ut(zeit1, zeitzone)
   jahr=zeit.jahr; monat=zeit.monat; tag=zeit.tag; stunde=zeit.stunde
  }
 else
  {jahr=jahr1; monat=monat1; tag=tag1; stunde=stunde1
  }
 val n:Double = MJD(jahr,monat,tag,stunde,minute,sekunde) - 51544.5; //in MJD ist 2400000.5 schon subrahiert
 var L:Double = 280.460*GRAD + 0.9856474*GRAD*n; //mittlere Laenge
 var g:Double = 357.528*GRAD + 0.9856003*GRAD*n; //mittlere Anomalie
 //eventuell noch L und g in den Bereich von 0 bis 2Pi bringen:
 while(L>=ZWEIPI) {L-=ZWEIPI}
 while(g>=ZWEIPI) {g-=ZWEIPI}
 //printf("L=%f Grad, g=%f Grad\n",L/GRAD,g/GRAD);//test
 val Lambda:Double = L + 1.915*GRAD*sin(g) + 0.01997*GRAD*sin(2*g); //ekliptikale Laenge
 val epsilon:Double  = 23.439*GRAD - 0.0000004*GRAD*n; //Schiefe der Ekliptik
 val alfa:Double  = atan2(cos(epsilon)*sin(Lambda),cos(Lambda)); //Rektaszension
 val delta:Double  = asin(sin(epsilon)*sin(Lambda)); //Deklination
 //double T0 = (JD(jahr,monat,tag,0,0,0) - 2451545.0)/36525.0;
 val T0:Double  = (MJD(jahr,monat,tag,0,0,0) - 51544.5)/36525.0;
 val T:Double  = stunde+minute/60.0+sekunde/3600.0;
 var thetahg:Double  = 6.697376 + 2400.05134*T0 + 1.002738*T;
 while(thetahg>=24.0) {thetahg -= 24.0}
 val thetag:Double  = thetahg*15*GRAD; //mittlere Sternzeit
 val theta:Double  = thetag+lon*GRAD; //Stundenwinkel des Fruehlingspunkts
 val tau:Double  = theta-alfa; //Stundenwinkel der Sonne
 val phi:Double  = lat*GRAD; //Geographische Breite
 val azimut:Double = atan2(sin(tau), cos(tau)*sin(phi) - tan(delta)*cos(phi));
 var hoehe:Double = asin(cos(delta)*cos(tau)*cos(phi) + sin(delta)*sin(phi));
 //Refraktion beruecksichtigen:
 if(refraktflag!=0 && hoehe<45*GRAD && hoehe > -45*GRAD)
  {
   var h:Double = hoehe/GRAD;
   if(h<0) {if(h < -2)  h = -(h+2); else h=0.0;}
   val R:Double = 1.02/tan((h+10.3/(h+5.11))*GRAD); //Refraktion in Winkelminuten
   //if(argflag['V']) printf("R=%f Winkelminuten\n",R);//test
   hoehe += R*WINKELMINUTE;
  }
 return hoeheAzimut(hoehe,azimut)
}

fun umrechnung_zonenzeit_nach_ut(zeit:jahrMonatTagStunde, zeitzone:Int):jahrMonatTagStunde
{
 var jahr:Int = zeit.jahr
 var monat:Int = zeit.monat
 var tag:Int = zeit.tag
 var stunde:Int = zeit.stunde
 var schaltjahr:Int = 0
 if((jahr%4)==0 && (jahr%100!=0 || jahr%400==0)) schaltjahr=1;
 stunde -= zeitzone;
 if(stunde>=24)
  {
   var max:Int
   stunde -= 24;
   if(schaltjahr==1 && monat==2) max=29;
   else max=monatstage[monat];
   if(++tag>max)
    {
     tag=1;
     if(++monat==13) {monat=1; ++jahr;}
    }
  }
 else if(stunde<0)
  {
   stunde += 24;
   if(--tag==0)
    {
     if(--monat==0) {tag=31; monat=12; --jahr;}
     else
      {
       if(schaltjahr==1 && monat==2) tag=29;
       else tag=monatstage[monat];
      }
    }
  }
 return jahrMonatTagStunde(jahr,monat,tag,stunde)
}
