package ch.rolfp.mond
import kotlin.math.*

const val AE=1.4959787e11	//Astronomische Einheit in Meter
class Sun200 {
    var c3: ArrayReal = ArrayReal(-1, 7)
    var s3: ArrayReal = ArrayReal(-1, 7)
    var c: ArrayReal = ArrayReal(-8, 0)
    var s: ArrayReal = ArrayReal(-8, 0)
    var m2 = 0.0
    var m3 = 0.0
    var m4 = 0.0
    var m5 = 0.0
    var m6 = 0.0
    var d = 0.0
    var a = 0.0
    var uu = 0.0
    var u = 0.0
    var v = 0.0
    var dl = 0.0
    var dr = 0.0
    var db = 0.0
    var sun200_t = 0.0

    fun term(i1: Int, i: Int, it: Int, dlc: Double, dls: Double, drc: Double, drs: Double, dbc: Double, dbs: Double) {
        if (it == 0) {val (a, b) = addthe(c3[i1], s3[i1], c[i], s[i]); u = a; v = b}
        else {u *= sun200_t; v *= sun200_t}
        dl += dlc * u + dls * v
        dr += drc * u + drs * v
        db += dbc * u + dbs * v
    }

    fun pertven() { /* Keplerian terms and perturbations by Venus */
        c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m2); s[-1] = -sin(m2)
        for (i in -1 downTo -5) {
            val (a, b) = addthe(c[i], s[i], c[-1], s[-1]); c[i - 1] = a; s[i - 1] = b
        }
        term(1, 0, 0, -0.22, 6892.76, -16707.37, -0.54, 0.00, 0.00)
        term(1, 0, 1, -0.06, -17.35, 42.04, -0.15, 0.00, 0.00)
        term(1, 0, 2, -0.01, -0.05, 0.13, -0.02, 0.00, 0.00)
        term(2, 0, 0, 0.00, 71.98, -139.57, 0.00, 0.00, 0.00)
        term(2, 0, 1, 0.00, -0.36, 0.70, 0.00, 0.00, 0.00)
        term(3, 0, 0, 0.00, 1.04, -1.75, 0.00, 0.00, 0.00)
        term(0, -1, 0, 0.03, -0.07, -0.16, -0.07, 0.02, -0.02)
        term(1, -1, 0, 2.35, -4.23, -4.75, -2.64, 0.00, 0.00)
        term(1, -2, 0, -0.10, 0.06, 0.12, 0.20, 0.02, 0.00)
        term(2, -1, 0, -0.06, -0.03, 0.20, -0.01, 0.01, -0.09)
        term(2, -2, 0, -4.70, 2.90, 8.28, 13.42, 0.01, -0.01)
        term(3, -2, 0, 1.80, -1.74, -1.44, -1.57, 0.04, -0.06)
        term(3, -3, 0, -0.67, 0.03, 0.11, 2.43, 0.01, 0.00)
        term(4, -2, 0, 0.03, -0.03, 0.10, 0.09, 0.01, -0.01)
        term(4, -3, 0, 1.51, -0.40, -0.88, -3.36, 0.18, -0.10)
        term(4, -4, 0, -0.19, -0.09, -0.38, 0.77, 0.00, 0.00)
        term(5, -3, 0, 0.76, -0.68, 0.30, 0.37, 0.01, 0.00)
        term(5, -4, 0, -0.14, -0.04, -0.11, 0.43, -0.03, 0.00)
        term(5, -5, 0, -0.05, -0.07, -0.31, 0.21, 0.00, 0.00)
        term(6, -4, 0, 0.15, -0.04, -0.06, -0.21, 0.01, 0.00)
        term(6, -5, 0, -0.03, -0.03, -0.09, 0.09, -0.01, 0.00)
        term(6, -6, 0, 0.00, -0.04, -0.18, 0.02, 0.00, 0.00)
        term(7, -5, 0, -0.12, -0.03, -0.08, 0.31, -0.02, -0.01)
    }

    fun pertmar() { /* perturbations by Mars */
        c[-1] = cos(m4); s[-1] = -sin(m4)
        for (i in -1 downTo -7) {
            val (a, b) = addthe(c[i], s[i], c[-1], s[-1]); c[i - 1] = a; s[i - 1] = b
        }
        term(1, -1, 0, -0.22, 0.17, -0.21, -0.27, 0.00, 0.00)
        term(1, -2, 0, -1.66, 0.62, 0.16, 0.28, 0.00, 0.00)
        term(2, -2, 0, 1.96, 0.57, -1.32, 4.55, 0.00, 0.01)
        term(2, -3, 0, 0.40, 0.15, -0.17, 0.46, 0.00, 0.00)
        term(2, -4, 0, 0.53, 0.26, 0.09, -0.22, 0.00, 0.00)
        term(3, -3, 0, 0.05, 0.12, -0.35, 0.15, 0.00, 0.00)
        term(3, -4, 0, -0.13, -0.48, 1.06, -0.29, 0.01, 0.00)
        term(3, -5, 0, -0.04, -0.20, 0.20, -0.04, 0.00, 0.00)
        term(4, -4, 0, 0.00, -0.03, 0.10, 0.04, 0.00, 0.00)
        term(4, -5, 0, 0.05, -0.07, 0.20, 0.14, 0.00, 0.00)
        term(4, -6, 0, -0.10, 0.11, -0.23, -0.22, 0.00, 0.00)
        term(5, -7, 0, -0.05, 0.00, 0.01, -0.14, 0.00, 0.00)
        term(5, -8, 0, 0.05, 0.01, -0.02, 0.10, 0.00, 0.00)
    }

    fun pertjup() { /* perturbations by Jupiter */
        c[-1] = cos(m5); s[-1] = -sin(m5)
        for (i in -1 downTo -3) {
            val (a, b) = addthe(c[i], s[i], c[-1], s[-1]); c[i - 1] = a; s[i - 1] = b
        }
        term(-1, -1, 0, 0.01, 0.07, 0.18, -0.02, 0.00, -0.02)
        term(0, -1, 0, -0.31, 2.58, 0.52, 0.34, 0.02, 0.00)
        term(1, -1, 0, -7.21, -0.06, 0.13, -16.27, 0.00, -0.02)
        term(1, -2, 0, -0.54, -1.52, 3.09, -1.12, 0.01, -0.17)
        term(1, -3, 0, -0.03, -0.21, 0.38, -0.06, 0.00, -0.02)
        term(2, -1, 0, -0.16, 0.05, -0.18, -0.31, 0.01, 0.00)
        term(2, -2, 0, 0.14, -2.73, 9.23, 0.48, 0.00, 0.00)
        term(2, -3, 0, 0.07, -0.55, 1.83, 0.25, 0.01, 0.00)
        term(2, -4, 0, 0.02, -0.08, 0.25, 0.06, 0.00, 0.00)
        term(3, -2, 0, 0.01, -0.07, 0.16, 0.04, 0.00, 0.00)
        term(3, -3, 0, -0.16, -0.03, 0.08, -0.64, 0.00, 0.00)
        term(3, -4, 0, -0.04, -0.01, 0.03, -0.17, 0.00, 0.00)
    }

    fun pertsat() { /* perturbations by Saturn */
        c[-1] = cos(m6); s[-1] = -sin(m6)
        val (a, b) = addthe(c[-1], s[-1], c[-1], s[-1]); c[-2] = a; s[-2] = b
        term(0, -1, 0, 0.00, 0.32, 0.01, 0.00, 0.00, 0.00)
        term(1, -1, 0, -0.08, -0.41, 0.97, -0.18, 0.00, -0.01)
        term(1, -2, 0, 0.04, 0.10, -0.23, 0.10, 0.00, 0.00)
        term(2, -2, 0, 0.04, 0.10, -0.35, 0.13, 0.00, 0.00)
    }

    fun pertmoo() { /* difference between the Earth-Moon      */
        /* barycenter and the center of the Earth */
        dl += 6.45 * sin(d) - 0.42 * sin(d - a) + 0.18 * sin(d + a) + 0.17 * sin(d - m3) - 0.06 * sin(d + m3)
        dr += 30.76 * cos(d) - 3.06 * cos(d - a) + 0.85 * cos(d + a) - 0.58 * cos(d + m3) + 0.57 * cos(d - m3)
        db += 0.576 * sin(uu)
    }

    fun sunStart(t: Double): Triple<Double, Double, Double> {
        sun200_t = t
        dl = 0.0; dr = 0.0; db = 0.0
        m2 = p2 * frac(0.1387306 + 162.5485917 * t)
        m3 = p2 * frac(0.9931266 + 99.9973604 * t)
        m4 = p2 * frac(0.0543250 + 53.1666028 * t)
        m5 = p2 * frac(0.0551750 + 8.4293972 * t)
        m6 = p2 * frac(0.8816500 + 3.3938722 * t); d = p2 * frac(0.8274 + 1236.8531 * t)
        a = p2 * frac(0.3749 + 1325.5524 * t); uu = p2 * frac(0.2591 + 1342.2278 * t)
        c3[0] = 1.0; s3[0] = 0.0
        c3[1] = cos(m3); s3[1] = sin(m3); c3[-1] = c3[1]; s3[-1] = -s3[1]
        for (i in 2..7) {
            val (a, b) = addthe(c3[i - 1], s3[i - 1], c3[1], s3[1]); c3[i] = a; s3[i] = b
        }
        pertven(); pertmar(); pertjup(); pertsat(); pertmoo()
        dl += 6.40 * sin(p2 * (0.6983 + 0.0561 * t)) + 1.87 * sin(p2 * (0.5764 + 0.4174 * t))
        +0.27 * sin(p2 * (0.4189 + 0.3306 * t)) + 0.20 * sin(p2 * (0.3581 + 2.4814 * t))
        val l = 360.0 * frac(0.7859453 + m3 / p2 + ((6191.2 + 1.1 * t) * t + dl) / 1296.0e3)
        val r = 1.0001398 - 0.0000007 * t + dr * 1e-6
        val b = db / 3600.0
        return Triple(l, b, r)
    }
}

val sun200 = Sun200()  //Verwendung: val(l,b,r)=sun200.sunStart(tt)
var sunPosx=0.0; var sunPosy=0.0; var sunPosz=0.0

fun quadrat(x:Double): Double {return x*x}
fun calcSunPos(tt:Double):Unit {
    val(ls,bs,rs) = sun200.sunStart(tt) // rs ist Abstand zur Erde in AE
    val p = geocen(tt, ls,bs,rs, ls, bs, rs, 3, 2)
    sunPosx=p[3]*AE; sunPosy=p[4]*AE; sunPosz=p[5]*AE; sonneAbstand=rs*AE
}
