package ch.rolfp.mond

import kotlin.math.*
class Merkur200 {
    var c1:ArrayReal = ArrayReal(-1,9); var s1:ArrayReal = ArrayReal(-1,9)
    var c:ArrayReal = ArrayReal(-5,0); var s:ArrayReal = ArrayReal(-5,0)
    var m1:Double=0.0; var m2:Double=0.0; var m3:Double=0.0; var m5:Double=0.0; var m6:Double=0.0
    var u:Double=0.0; var v:Double=0.0; var dl:Double=0.0; var dr:Double=0.0; var db:Double=0.0; var t:Double=0.0
    
    fun term(j:Int,i:Int,it:Int, dlc:Double, dls:Double, drc:Double, drs:Double, dbc:Double, dbs:Double) {
        if(it==0) {val(a,b)=addthe(c1[j],s1[j],c[i],s[i]); u=a; v=b}
        else  {u *= t; v *= t;}
        dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v
    }

    fun merkur_pertven() { // Kepler terms and perturbations by Venus
        c[0] = 1.0; s[0] = 0.0;  c[-1] = cos(m2); s[-1] = -sin(m2)
        for(i in -1 downTo -4) {val(a,b)=addthe(c[i],s[i],c[-1],s[-1]); c[i-1]=a; s[i-1]=b}
        term( 1, 0,0, 259.74,84547.39,-78342.34, 0.01,11683.22,21203.79)
        term( 1, 0,1,   2.30,    5.04,    -7.52, 0.02,  138.55,  -71.01)
        term( 1, 0,2,   0.01,   -0.01,     0.01, 0.01,   -0.19,   -0.54)
        term( 2, 0,0,-549.71,10394.44, -7955.45, 0.00, 2390.29, 4306.79)
        term( 2, 0,1,  -4.77,    8.97,    -1.53, 0.00,   28.49,  -14.18)
        term( 2, 0,2,   0.00,    0.00,     0.00, 0.00,   -0.04,   -0.11)
        term( 3, 0,0,-234.04, 1748.74, -1212.86, 0.00,  535.41,  984.33)
        term( 3, 0,1,  -2.03,    3.48,    -0.35, 0.00,    6.56,   -2.91)
        term( 4, 0,0, -77.64,  332.63,  -219.23, 0.00,  124.40,  237.03)
        term( 4, 0,1,  -0.70,    1.10,    -0.08, 0.00,    1.59,   -0.59)
        term( 5, 0,0, -23.59,   67.28,   -43.54, 0.00,   29.44,   58.77)
        term( 5, 0,1,  -0.23,    0.32,    -0.02, 0.00,    0.39,   -0.11)
        term( 6, 0,0,  -6.86,   14.06,    -9.18, 0.00,    7.03,   14.84)
        term( 6, 0,1,  -0.07,    0.09,    -0.01, 0.00,    0.10,   -0.02)
        term( 7, 0,0,  -1.94,    2.98,    -2.02, 0.00,    1.69,    3.80)
        term( 8, 0,0,  -0.54,    0.63,    -0.46, 0.00,    0.41,    0.98)
        term( 9, 0,0,  -0.15,    0.13,    -0.11, 0.00,    0.10,    0.25)
        term(-1,-2,0,  -0.17,   -0.06,    -0.05, 0.14,   -0.06,   -0.07)
        term( 0,-1,0,   0.24,   -0.16,    -0.11,-0.16,    0.04,   -0.01)
        term( 0,-2,0,  -0.68,   -0.25,    -0.26, 0.73,   -0.16,   -0.18)
        term( 0,-5,0,   0.37,    0.08,     0.06,-0.28,    0.13,    0.12)
        term( 1,-1,0,   0.58,   -0.41,     0.26, 0.36,    0.01,   -0.01)
        term( 1,-2,0,  -3.51,   -1.23,     0.23,-0.63,   -0.05,   -0.06)
        term( 1,-3,0,   0.08,    0.53,    -0.11, 0.04,    0.02,   -0.09)
        term( 1,-5,0,   1.44,    0.31,     0.30,-1.39,    0.34,    0.29)
        term( 2,-1,0,   0.15,   -0.11,     0.09, 0.12,    0.02,   -0.04)
        term( 2,-2,0,  -1.99,   -0.68,     0.65,-1.91,   -0.20,    0.03)
        term( 2,-3,0,  -0.34,   -1.28,     0.97,-0.26,    0.03,    0.03)
        term( 2,-4,0,  -0.33,    0.35,    -0.13,-0.13,   -0.01,    0.00)
        term( 2,-5,0,   7.19,    1.56,    -0.05, 0.12,    0.06,    0.05)
        term( 3,-2,0,  -0.52,   -0.18,     0.13,-0.39,   -0.16,    0.03)
        term( 3,-3,0,  -0.11,   -0.42,     0.36,-0.10,   -0.05,   -0.05)
        term( 3,-4,0,  -0.19,    0.22,    -0.23,-0.20,   -0.01,    0.02)
        term( 3,-5,0,   2.77,    0.49,    -0.45, 2.56,    0.40,   -0.12)
        term( 4,-5,0,   0.67,    0.12,    -0.09, 0.47,    0.24,   -0.08)
        term( 5,-5,0,   0.18,    0.03,    -0.02, 0.12,    0.09,   -0.03)
    }

    fun merkur_pertear() { // perturbations by the Earth
        c[-1] = cos(m3); s[-1] = -sin(m3)
        for(i in -1 downTo -3) {val(a,b)=addthe(c[i],s[i],c[-1],s[-1]); c[i-1]=a; s[i-1]=b}
        term( 0,-4,0,  -0.11,   -0.07,    -0.08, 0.11,   -0.02,   -0.04)
        term( 1,-1,0,   0.10,   -0.20,     0.15, 0.07,    0.00,    0.00)
        term( 1,-2,0,  -0.35,    0.28,    -0.13,-0.17,   -0.01,    0.00)
        term( 1,-4,0,  -0.67,   -0.45,     0.00, 0.01,   -0.01,   -0.01)
        term( 2,-2,0,  -0.20,    0.16,    -0.16,-0.20,   -0.01,    0.02)
        term( 2,-3,0,   0.13,   -0.02,     0.02, 0.14,    0.01,    0.00)
        term( 2,-4,0,  -0.33,   -0.18,     0.17,-0.31,   -0.04,    0.00)
    }

    fun merkur_pertjup() { // perturbations by Jupiter
        c[-1] = cos(m5); s[-1] = -sin(m5)
        for(i in -1 downTo -2) {val(a,b)=addthe(c[i],s[i],c[-1],s[-1]); c[i-1]=a; s[i-1]=b}
        term(-1,-1,0,  -0.08,    0.16,     0.15, 0.08,   -0.04,    0.01)
        term(-1,-2,0,   0.10,   -0.06,    -0.07,-0.12,    0.07,   -0.01)
        term( 0,-1,0,  -0.31,    0.48,    -0.02, 0.13,   -0.03,   -0.02)
        term( 0,-2,0,   0.42,   -0.26,    -0.38,-0.50,    0.20,   -0.03)
        term( 1,-1,0,  -0.70,    0.01,    -0.02,-0.63,    0.00,    0.03)
        term( 1,-2,0,   2.61,   -1.97,     1.74, 2.32,    0.01,    0.01)
        term( 1,-3,0,   0.32,   -0.15,     0.13, 0.28,    0.00,    0.00)
        term( 2,-1,0,  -0.18,    0.01,     0.00,-0.13,   -0.03,    0.03)
        term( 2,-2,0,   0.75,   -0.56,     0.45, 0.60,    0.08,   -0.17)
        term( 3,-2,0,   0.20,   -0.15,     0.10, 0.14,    0.04,   -0.08)
    }

    fun merkur_pertsat() { // perturbations by Saturn
        c[-2] = cos(2*m6); s[-2] = -sin(2*m6)
        term( 1,-2,0,  -0.19,    0.33,     0.00, 0.00,    0.00,    0.00)
    }

    fun merkur_start(t0:Double): Triple<Double,Double,Double> {
        dl=0.0; dr=0.0; db=0.0; t=t0
        m1 = p2*frac(0.4855407+415.2014314*t)
        m2 = p2*frac(0.1394222+162.5490444*t)
        m3 = p2*frac(0.9937861+ 99.9978139*t)
        m5 = p2*frac(0.0558417+  8.4298417*t)
        m6 = p2*frac(0.8823333+  3.3943333*t)
        c1[0] = 1.0;     s1[0] = 0.0
        c1[1] = cos(m1); s1[1] = sin(m1);  c1[-1] = c1[1]; s1[-1] = -s1[1]
        for(i in 2..9) {val(a,b)=addthe(c1[i-1],s1[i-1],c1[1],s1[1]); c1[i]=a; s1[i]=b}
        merkur_pertven(); merkur_pertear(); merkur_pertjup(); merkur_pertsat()
        dl += 2.8+3.2*t
        val l = 360.0*frac(0.2151379 + m1/p2 + ((5601.7+1.1*t)*t+dl)/1296.0e3 )
        val r = 0.3952829 + 0.0000016*t  +  dr*1.0e-6
        val b = ( -2522.15 + (-30.18 + 0.04*t) * t  +  db ) / 3600.0
        return Triple(l,b,r)
    }
}

val merkur200 = Merkur200()

/* Aufruf:
    val(l,b,r) = merkur200.merkur_start(t);

mit c++ war das so:
    void mer200(double t,double& l,double& b,double& r) {
        merkur200.merkur_start(t,l,b,r)
    }
*/

class Venus200 {
    var c2=DoubleArray(9); var s2=DoubleArray(9)
    var c:ArrayReal = ArrayReal(-8,0); var s:ArrayReal = ArrayReal(-8,0)
    var m1:Double=0.0; var m2:Double=0.0; var m3:Double=0.0; var m4:Double=0.0; var m5:Double=0.0; var m6:Double=0.0
    var u:Double=0.0; var v:Double=0.0; var dl:Double=0.0; var dr:Double=0.0; var db:Double=0.0; var t:Double=0.0

    fun term(j:Int,i:Int,it:Int, dlc:Double, dls:Double, drc:Double, drs:Double, dbc:Double, dbs:Double) {
        if(it==0) {val(a,b)=addthe(c2[j],s2[j],c[i],s[i]); u=a; v=b}
        else  {u *= t; v *= t;}
        dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v
    }

    fun venus_pertmer() { // perturbations by Mercury 
        c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m1); s[-1] = -sin(m1);
        {val(a,b)=addthe(c[-1],s[-1],c[-1],s[-1]); c[-2]=a; s[-2]=b}
        term(1,-1,0,   0.00,   0.00,    0.06, -0.09,   0.01,   0.00)
        term(2,-1,0,   0.25,  -0.09,   -0.09, -0.27,   0.00,   0.00)
        term(4,-2,0,  -0.07,  -0.08,   -0.14,  0.14,  -0.01,  -0.01)
        term(5,-2,0,  -0.35,   0.08,    0.02,  0.09,   0.00,   0.00)
    }

    fun venus_pertear() { // Kepler terms and perturbations by the Earth 
        c[-1] = cos(m3); s[-1] = -sin(m3)
        for(i in -1 downTo -7) {val(a,b)=addthe(c[i],s[i],c[-1],s[-1]); c[i-1]=a; s[i-1]=b}
        term(1, 0,0,   2.37,2793.23,-4899.07,  0.11,9995.27,7027.22)
        term(1, 0,1,   0.10, -19.65,   34.40,  0.22,  64.95, -86.10)
        term(1, 0,2,   0.06,   0.04,   -0.07,  0.11,  -0.55,  -0.07)
        term(2, 0,0,-170.42,  73.13,  -16.59,  0.00,  67.71,  47.56)
        term(2, 0,1,   0.93,   2.91,    0.23,  0.00,  -0.03,  -0.92)
        term(3, 0,0,  -2.31,   0.90,   -0.08,  0.00,   0.04,   2.09)
        term(1,-1,0,  -2.38,  -4.27,    3.27, -1.82,   0.00,   0.00)
        term(1,-2,0,   0.09,   0.00,   -0.08,  0.05,  -0.02,  -0.25)
        term(2,-2,0,  -9.57,  -5.93,    8.57,-13.83,  -0.01,  -0.01)
        term(2,-3,0,  -2.47,  -2.40,    0.83, -0.95,   0.16,   0.24)
        term(3,-2,0,  -0.09,  -0.05,    0.08, -0.13,  -0.28,   0.12)
        term(3,-3,0,   7.12,   0.32,   -0.62, 13.76,  -0.07,   0.01)
        term(3,-4,0,  -0.65,  -0.17,    0.18, -0.73,   0.10,   0.05)
        term(3,-5,0,  -1.08,  -0.95,   -0.17,  0.22,  -0.03,  -0.03)
        term(4,-3,0,   0.06,   0.00,   -0.01,  0.08,   0.14,  -0.18)
        term(4,-4,0,   0.93,  -0.46,    1.06,  2.13,  -0.01,   0.01)
        term(4,-5,0,  -1.53,   0.38,   -0.64, -2.54,   0.27,   0.00)
        term(4,-6,0,  -0.17,  -0.05,    0.03, -0.11,   0.02,   0.00)
        term(5,-5,0,   0.18,  -0.28,    0.71,  0.47,  -0.02,   0.04)
        term(5,-6,0,   0.15,  -0.14,    0.30,  0.31,  -0.04,   0.03)
        term(5,-7,0,  -0.08,   0.02,   -0.03, -0.11,   0.01,   0.00)
        term(5,-8,0,  -0.23,   0.00,    0.01, -0.04,   0.00,   0.00)
        term(6,-6,0,   0.01,  -0.14,    0.39,  0.04,   0.00,  -0.01)
        term(6,-7,0,   0.02,  -0.05,    0.12,  0.04,  -0.01,   0.01)
        term(6,-8,0,   0.10,  -0.10,    0.19,  0.19,  -0.02,   0.02)
        term(7,-7,0,  -0.03,  -0.06,    0.18, -0.08,   0.00,   0.00)
        term(8,-8,0,  -0.03,  -0.02,    0.06, -0.08,   0.00,   0.00)
    }

    fun venus_pertmar() { // perturbations by Mars 
        c[-1] = cos(m4); s[-1] = -sin(m4)
        for(i in -1 downTo -2) {val(a,b)=addthe(c[i],s[i],c[-1],s[-1]); c[i-1]=a; s[i-1]=b}
        term(1,-3,0,  -0.65,   1.02,   -0.04, -0.02,  -0.02,   0.00)
        term(2,-2,0,  -0.05,   0.04,   -0.09, -0.10,   0.00,   0.00)
        term(2,-3,0,  -0.50,   0.45,   -0.79, -0.89,   0.01,   0.03)
    }

    fun venus_pertjup() { // perturbations by Jupiter 
        c[-1] = cos(m5); s[-1] = -sin(m5)
        for(i in -1 downTo -2) {val(a,b)=addthe(c[i],s[i],c[-1],s[-1]); c[i-1]=a; s[i-1]=b}
        term(0,-1,0,  -0.05,   1.56,    0.16,  0.04,  -0.08,  -0.04)
        term(1,-1,0,  -2.62,   1.40,   -2.35, -4.40,   0.02,   0.03)
        term(1,-2,0,  -0.47,  -0.08,    0.12, -0.76,   0.04,  -0.18)
        term(2,-2,0,  -0.73,  -0.51,    1.27, -1.82,  -0.01,   0.01)
        term(2,-3,0,  -0.14,  -0.10,    0.25, -0.34,   0.00,   0.00)
        term(3,-3,0,  -0.01,   0.04,   -0.11, -0.02,   0.00,   0.00)
    }

    fun venus_pertsat() { // perturbations by Saturn 
        c[-1] = cos(m6); s[-1] = -sin(m6)
        term(0,-1,0,   0.00,   0.21,    0.00,  0.00,   0.00,  -0.01)
        term(1,-1,0,  -0.11,  -0.14,    0.24, -0.20,   0.01,   0.00)
    }

    fun venus_start(t0:Double): Triple<Double,Double,Double> {
        dl=0.0; dr=0.0; db=0.0; t=t0
        m1 = p2*frac(0.4861431+415.2018375*t)
        m2 = p2*frac(0.1400197+162.5494552*t)
        m3 = p2*frac(0.9944153+ 99.9982208*t)
        m4 = p2*frac(0.0556297+ 53.1674631*t)
        m5 = p2*frac(0.0567028+  8.4305083*t)
        m6 = p2*frac(0.8830539+  3.3947206*t)
        c2[0] = 1.0; s2[0] = 0.0; c2[1] = cos(m2); s2[1] = sin(m2)
        for(i in 2..8) {val(a,b)=addthe(c2[i-1],s2[i-1],c2[1],s2[1]); c2[i]=a; s2[i]=b}
        venus_pertmer(); venus_pertear(); venus_pertmar(); venus_pertjup(); venus_pertsat()
        dl += 2.74*sin(p2*(0.0764+0.4174*t))
        dl += 0.27*sin(p2*(0.9201+0.3307*t))
        dl += 1.9+1.8*t
        val l = 360.0*frac(0.3654783 + m2/p2 + ((5071.2+1.1*t)*t+dl)/1296.0e3 )
        val r = 0.7233482 - 0.0000002*t  +  dr*1.0e-6
        val b = ( -67.70 + ( 0.04 + 0.01*t) * t  +  db ) / 3600.0
        return Triple(l,b,r)
    }
}

val venus200 = Venus200()

/* Aufruf:
    val(l,b,r) = venus200.venus_start(t);
*/

class Mars200 {
    var c4:ArrayReal = ArrayReal(-2,16); var s4:ArrayReal = ArrayReal(-2,16)
    var c:ArrayReal = ArrayReal(-9,0); var s:ArrayReal = ArrayReal(-9,0)
    var m2:Double=0.0; var m3:Double=0.0; var m4:Double=0.0; var m5:Double=0.0; var m6:Double=0.0
    var u:Double=0.0; var v:Double=0.0; var dl:Double=0.0; var dr:Double=0.0; var db:Double=0.0; var t:Double=0.0
 
    fun term(j:Int,i:Int,it:Int, dlc:Double, dls:Double, drc:Double, drs:Double, dbc:Double, dbs:Double) {
        if(it==0) {val(a,b)=addthe(c4[j],s4[j],c[i],s[i]); u=a; v=b}
        else  {u *= t; v *= t;}
        dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v
    }

    fun mars_pertven() { // perturbations by Venus 
        c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m2); s[-1] = -sin(m2);
        {val(a,b)=addthe(c[-1],s[-1],c[-1],s[-1]); c[-2]=a; s[-2]=b}
        term( 0,-1,0, -0.01,   -0.03,      0.10, -0.04,    0.00,   0.00)
        term( 1,-1,0,  0.05,    0.10,     -2.08,  0.75,    0.00,   0.00)
        term( 2,-1,0, -0.25,   -0.57,     -2.58,  1.18,    0.05,  -0.04)
        term( 2,-2,0,  0.02,    0.02,      0.13, -0.14,    0.00,   0.00)
        term( 3,-1,0,  3.41,    5.38,      1.87, -1.15,    0.01,  -0.01)
        term( 3,-2,0,  0.02,    0.02,      0.11, -0.13,    0.00,   0.00)
        term( 4,-1,0,  0.32,    0.49,     -1.88,  1.21,   -0.07,   0.07)
        term( 4,-2,0,  0.03,    0.03,      0.12, -0.14,    0.00,   0.00)
        term( 5,-1,0,  0.04,    0.06,     -0.17,  0.11,   -0.01,   0.01)
        term( 5,-2,0,  0.11,    0.09,      0.35, -0.43,   -0.01,   0.01)
        term( 6,-2,0, -0.36,   -0.28,     -0.20,  0.25,    0.00,   0.00)
        term( 7,-2,0, -0.03,   -0.03,      0.11, -0.13,    0.00,  -0.01)
    }

    fun mars_pertear() { // Kepler terms and perturbations by the Earth 
        c[-1] = cos(m3); s[-1] = -sin(m3)
        for(i in -1 downTo -8) {val(a,b)=addthe(c[i],s[i],c[-1],s[-1]); c[i-1]=a; s[i-1]=b}
        term( 1, 0,0, -5.32,38481.97,-141856.04,  0.40,-6321.67,1876.89)
        term( 1, 0,1, -1.12,   37.98,   -138.67, -2.93,   37.28, 117.48)
        term( 1, 0,2, -0.32,   -0.03,      0.12, -1.19,    1.04,  -0.40)
        term( 2, 0,0, 28.28, 2285.80,  -6608.37,  0.00, -589.35, 174.81)
        term( 2, 0,1,  1.64,    3.37,    -12.93,  0.00,    2.89,  11.10)
        term( 2, 0,2,  0.00,    0.00,      0.00,  0.00,    0.10,  -0.03)
        term( 3, 0,0,  5.31,  189.29,   -461.81,  0.00,  -61.98,  18.53)
        term( 3, 0,1,  0.31,    0.35,     -1.36,  0.00,    0.25,   1.19)
        term( 4, 0,0,  0.81,   17.96,    -38.26,  0.00,   -6.88,   2.08)
        term( 4, 0,1,  0.05,    0.04,     -0.15,  0.00,    0.02,   0.14)
        term( 5, 0,0,  0.11,    1.83,     -3.48,  0.00,   -0.79,   0.24)
        term( 6, 0,0,  0.02,    0.20,     -0.34,  0.00,   -0.09,   0.03)
        term(-1,-1,0,  0.09,    0.06,      0.14, -0.22,    0.02,  -0.02)
        term( 0,-1,0,  0.72,    0.49,      1.55, -2.31,    0.12,  -0.10)
        term( 1,-1,0,  7.00,    4.92,     13.93,-20.48,    0.08,  -0.13)
        term( 2,-1,0, 13.08,    4.89,     -4.53, 10.01,   -0.05,   0.13)
        term( 2,-2,0,  0.14,    0.05,     -0.48, -2.66,    0.01,   0.14)
        term( 3,-1,0,  1.38,    0.56,     -2.00,  4.85,   -0.01,   0.19)
        term( 3,-2,0, -6.85,    2.68,      8.38, 21.42,    0.00,   0.03)
        term( 3,-3,0, -0.08,    0.20,      1.20,  0.46,    0.00,   0.00)
        term( 4,-1,0,  0.16,    0.07,     -0.19,  0.47,   -0.01,   0.05)
        term( 4,-2,0, -4.41,    2.14,     -3.33, -7.21,   -0.07,  -0.09)
        term( 4,-3,0, -0.12,    0.33,      2.22,  0.72,   -0.03,  -0.02)
        term( 4,-4,0, -0.04,   -0.06,     -0.36,  0.23,    0.00,   0.00)
        term( 5,-2,0, -0.44,    0.21,     -0.70, -1.46,   -0.06,  -0.07)
        term( 5,-3,0,  0.48,   -2.60,     -7.25, -1.37,    0.00,   0.00)
        term( 5,-4,0, -0.09,   -0.12,     -0.66,  0.50,    0.00,   0.00)
        term( 5,-5,0,  0.03,    0.00,      0.01, -0.17,    0.00,   0.00)
        term( 6,-2,0, -0.05,    0.03,     -0.07, -0.15,   -0.01,  -0.01)
        term( 6,-3,0,  0.10,   -0.96,      2.36,  0.30,    0.04,   0.00)
        term( 6,-4,0, -0.17,   -0.20,     -1.09,  0.94,    0.02,  -0.02)
        term( 6,-5,0,  0.05,    0.00,      0.00, -0.30,    0.00,   0.00)
        term( 7,-3,0,  0.01,   -0.10,      0.32,  0.04,    0.02,   0.00)
        term( 7,-4,0,  0.86,    0.77,      1.86, -2.01,    0.01,  -0.01)
        term( 7,-5,0,  0.09,   -0.01,     -0.05, -0.44,    0.00,   0.00)
        term( 7,-6,0, -0.01,    0.02,      0.10,  0.08,    0.00,   0.00)
        term( 8,-4,0,  0.20,    0.16,     -0.53,  0.64,   -0.01,   0.02)
        term( 8,-5,0,  0.17,   -0.03,     -0.14, -0.84,    0.00,   0.01)
        term( 8,-6,0, -0.02,    0.03,      0.16,  0.09,    0.00,   0.00)
        term( 9,-5,0, -0.55,    0.15,      0.30,  1.10,    0.00,   0.00)
        term( 9,-6,0, -0.02,    0.04,      0.20,  0.10,    0.00,   0.00)
        term(10,-5,0, -0.09,    0.03,     -0.10, -0.33,    0.00,  -0.01)
        term(10,-6,0, -0.05,    0.11,      0.48,  0.21,   -0.01,   0.00)
        term(11,-6,0,  0.10,   -0.35,     -0.52, -0.15,    0.00,   0.00)
        term(11,-7,0, -0.01,   -0.02,     -0.10,  0.07,    0.00,   0.00)
        term(12,-6,0,  0.01,   -0.04,      0.18,  0.04,    0.01,   0.00)
        term(12,-7,0, -0.05,   -0.07,     -0.29,  0.20,    0.01,   0.00)
        term(13,-7,0,  0.23,    0.27,      0.25, -0.21,    0.00,   0.00)
        term(14,-7,0,  0.02,    0.03,     -0.10,  0.09,    0.00,   0.00)
        term(14,-8,0,  0.05,    0.01,      0.03, -0.23,    0.00,   0.03)
        term(15,-8,0, -1.53,    0.27,      0.06,  0.42,    0.00,   0.00)
        term(16,-8,0, -0.14,    0.02,     -0.10, -0.55,   -0.01,  -0.02)
        term(16,-9,0,  0.03,   -0.06,     -0.25, -0.11,    0.00,   0.00)
    }

    fun mars_pertjup() { // perturbations by Jupiter 
        c[-1] = cos(m5); s[-1] = -sin(m5)
        for(i in -1 downTo -4) {val(a,b)=addthe(c[i],s[i],c[-1],s[-1]); c[i-1]=a; s[i-1]=b}
        term(-2,-1,0,  0.05,    0.03,      0.08, -0.14,    0.01,  -0.01)
        term(-1,-1,0,  0.39,    0.27,      0.92, -1.50,   -0.03,  -0.06)
        term(-1,-2,0, -0.16,    0.03,      0.13,  0.67,   -0.01,   0.06)
        term(-1,-3,0, -0.02,    0.01,      0.05,  0.09,    0.00,   0.01)
        term( 0,-1,0,  3.56,    1.13,     -5.41, -7.18,   -0.25,  -0.24)
        term( 0,-2,0, -1.44,    0.25,      1.24,  7.96,    0.02,   0.31)
        term( 0,-3,0, -0.21,    0.11,      0.55,  1.04,    0.01,   0.05)
        term( 0,-4,0, -0.02,    0.02,      0.11,  0.11,    0.00,   0.01)
        term( 1,-1,0, 16.67,  -19.15,     61.00, 53.36,   -0.06,  -0.07)
        term( 1,-2,0,-21.64,    3.18,     -7.77,-54.64,   -0.31,   0.50)
        term( 1,-3,0, -2.82,    1.45,     -2.53, -5.73,    0.01,   0.07)
        term( 1,-4,0, -0.31,    0.28,     -0.34, -0.51,    0.00,   0.00)
        term( 2,-1,0,  2.15,   -2.29,      7.04,  6.94,    0.33,   0.19)
        term( 2,-2,0,-15.69,    3.31,    -15.70,-73.17,   -0.17,  -0.25)
        term( 2,-3,0, -1.73,    1.95,     -9.19, -7.20,    0.02,  -0.03)
        term( 2,-4,0, -0.01,    0.33,     -1.42,  0.08,    0.01,  -0.01)
        term( 2,-5,0,  0.03,    0.03,     -0.13,  0.12,    0.00,   0.00)
        term( 3,-1,0,  0.26,   -0.28,      0.73,  0.71,    0.08,   0.04)
        term( 3,-2,0, -2.06,    0.46,     -1.61, -6.72,   -0.13,  -0.25)
        term( 3,-3,0, -1.28,   -0.27,      2.21, -6.90,   -0.04,  -0.02)
        term( 3,-4,0, -0.22,    0.08,     -0.44, -1.25,    0.00,   0.01)
        term( 3,-5,0, -0.02,    0.03,     -0.15, -0.08,    0.00,   0.00)
        term( 4,-1,0,  0.03,   -0.03,      0.08,  0.08,    0.01,   0.01)
        term( 4,-2,0, -0.26,    0.06,     -0.17, -0.70,   -0.03,  -0.05)
        term( 4,-3,0, -0.20,   -0.05,      0.22, -0.79,   -0.01,  -0.02)
        term( 4,-4,0, -0.11,   -0.14,      0.93, -0.60,    0.00,   0.00)
        term( 4,-5,0, -0.04,   -0.02,      0.09, -0.23,    0.00,   0.00)
        term( 5,-4,0, -0.02,   -0.03,      0.13, -0.09,    0.00,   0.00)
        term( 5,-5,0,  0.00,   -0.03,      0.21,  0.01,    0.00,   0.00)
    }

    fun mars_pertsat() { // perturbations by Saturn
        c[-1] = cos(m6); s[-1] = -sin(m6)
        for(i in -1 downTo -3) {val(a,b)=addthe(c[i],s[i],c[-1],s[-1]); c[i-1]=a; s[i-1]=b}
        term(-1,-1,0,  0.03,    0.13,      0.48, -0.13,    0.02,   0.00)
        term( 0,-1,0,  0.27,    0.84,      0.40, -0.43,    0.01,  -0.01)
        term( 0,-2,0,  0.12,   -0.04,     -0.33, -0.55,   -0.01,  -0.02)
        term( 0,-3,0,  0.02,   -0.01,     -0.07, -0.08,    0.00,   0.00)
        term( 1,-1,0,  1.12,    0.76,     -2.66,  3.91,   -0.01,   0.01)
        term( 1,-2,0,  1.49,   -0.95,      3.07,  4.83,    0.04,  -0.05)
        term( 1,-3,0,  0.21,   -0.18,      0.55,  0.64,    0.00,   0.00)
        term( 2,-1,0,  0.12,    0.10,     -0.29,  0.34,   -0.01,   0.02)
        term( 2,-2,0,  0.51,   -0.36,      1.61,  2.25,    0.03,   0.01)
        term( 2,-3,0,  0.10,   -0.10,      0.50,  0.43,    0.00,   0.00)
        term( 2,-4,0,  0.01,   -0.02,      0.11,  0.05,    0.00,   0.00)
        term( 3,-2,0,  0.07,   -0.05,      0.16,  0.22,    0.01,   0.01)
    }
 
    fun mars_start(t0:Double): Triple<Double,Double,Double> {
        dl=0.0; dr=0.0; db=0.0; t=t0
        m2 = p2*frac(0.1382208+162.5482542*t)
        m3 = p2*frac(0.9926208+99.9970236*t)
        m4 = p2*frac(0.0538553+ 53.1662736*t)
        m5 = p2*frac(0.0548944+ 8.4290611*t)
        m6 = p2*frac(0.8811167+  3.3935250*t)
        c4[0] = 1.0; s4[0] = 0.0;  c4[1] = cos(m4); s4[1] = sin(m4)
        for(i in 2 .. 16) {val(a,b)=addthe(c4[i-1],s4[i-1],c4[1],s4[1]); c4[i]=a; s4[i]=b}
        for(i in -2 .. -1)  {c4[i]=c4[-i]; s4[i]= -s4[-i];}
        mars_pertven(); mars_pertear(); mars_pertjup(); mars_pertsat()
        dl += 52.49*sin(p2*(0.1868+0.0549*t))
        dl += 0.61*sin(p2*(0.9220+0.3307*t))
        dl += 0.32*sin(p2*(0.4731+2.1485*t))
        dl += 0.28*sin(p2*(0.9467+0.1133*t))
        dl += 0.14+0.87*t-0.11*t*t
        val l = 360.0*frac(0.9334591 + m4/p2 + ((6615.5+1.1*t)*t+dl)/1296.0e3 )
        val r = 1.5303352 + 0.0000131*t  +  dr*1.0e-6
        val b = ( 596.32 + (-2.92 - 0.10*t) * t  +  db ) / 3600.0
        return Triple(l,b,r)
    }
}

val mars200 = Mars200()

fun planetEqu(nr:Int,tt:Double): Array<Double> {
    val(l,b,r) = if(nr==0) merkur200.merkur_start(tt)
                 else if(nr==2) mars200.mars_start(tt)
                 else if(nr==3) jupiter200.jupiter_start(tt)
                 else if(nr==4) saturn200.saturn_start(tt)
                 else venus200.venus_start(tt) //bei nr==1 oder wenn Fehler: Venus verwenden
    // l,b in Grad, r ist Abstand von Sonne in AE
    val imode=2 // 0=geometric,1=astrometric,2=apparent
    //val mode='A' //TODO: nachschauen in planetium und/oder Buch
    val iplan = if(nr>=2) nr+2 else nr+1
    //iplan is so definiert: 0=Sonne, 1=Merkur, 2=Venus, 3=Erde, 4=Mars ...

    val(ls,bs,rs) = sun200.sunStart(tt) // rs ist Abstand zur Erde in Meter
    val p = geocen(tt, l,b,r, ls, bs, rs, iplan, imode)
    //val xp=p[0]; val yp=p[1]; val zp=p[2]; val xs=p[3]; val ys=p[4]; val zs=p[5]
    var x=p[6]; var y=p[7]; var z=p[8]
    //val abstand=p[9] // Abstand Planet-Sonne in AE
    //if(mode=='A') {
        val(x2,y2,z2) = eclequ(tt,x,y,z)
        val(x3,y3,z3) = nutequ(tt,x2,y2,z2)
        x=x3; y=y3; z=z3
    //} else {
        /* TODO: falls anderer mode als 'A' gebraucht wird
        pmatecl(tt,teqx,amatrix);
        //precart(amatrix,xp,yp,zp);//ueberfluessig
        precart(amatrix,x,y,z); eclequ(teqx,x,y,z);
        */
    //}
    val(rr,dec,ra) = polar(x,y,z) //rr in AE; dec in [-90 deg,+90 deg]; ra in [0 deg,+360 deg])
    return arrayOf(ra,dec,rr,rs) // rr=Abstand Planet-Erde, rs=Abstand Sonne-Erde
}
