package ch.rolfp.mond
import kotlin.math.*
const val p2:Double = ZWEIPI

class Jupiter200 {
    var c5:ArrayReal = ArrayReal(-1,5); var s5:ArrayReal = ArrayReal(-1,5)
    var c:ArrayReal = ArrayReal(-10,0); var s:ArrayReal = ArrayReal(-10,0)
    var m5=0.0; var m6=0.0; var m7=0.0
    var u=0.0; var v=0.0; var dl=0.0; var dr=0.0; var db=0.0; var t=0.0
    
    fun term(j:Int,i:Int,it:Int, dlc:Double, dls:Double, drc:Double, drs:Double, dbc:Double, dbs:Double) {
        if(it==0) {val(a,b)=addthe(c5[j],s5[j],c[i],s[i]); u=a; v=b}
	    else  {u *= t; v *= t;}
	    dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v
    }
    
    fun jupiter_pertsat() { /* Kepler terms and perturbations by Saturn */
        c[0] = 1.0; s[0] = 0.0; c[-1] = cos(m6); s[-1] = -sin(m6)
	for(i in -1 downTo -9) {val(a,b)=addthe(c[i],s[i],c[-1],s[-1]); c[i-1]=a; s[i-1]=b}
	term(-1, -1,0,  -0.2,    1.4,     2.0,   0.6,    0.1, -0.2)
	term( 0, -1,0,   9.4,    8.9,     3.9,  -8.3,   -0.4, -1.4)
        term( 0, -2,0,   5.6,   -3.0,    -5.4,  -5.7,   -2.0,  0.0)
        term( 0, -3,0,  -4.0,   -0.1,     0.0,   5.5,    0.0,  0.0)
        term( 0, -5,0,   3.3,   -1.6,    -1.6,  -3.1,   -0.5, -1.2)
        term( 1,  0,0,-113.1,19998.6,-25208.2,-142.2,-4670.7,288.9)
        term( 1,  0,1, -76.1,   66.9,   -84.2, -95.8,   21.6, 29.4)
        term( 1,  0,2,  -0.5,   -0.3,     0.4,  -0.7,    0.1, -0.1)
        term( 1, -1,0,  78.8,  -14.5,    11.5,  64.4,   -0.2,  0.2)
        term( 1, -2,0,  -2.0, -132.4,    28.8,   4.3,   -1.7,  0.4)
        term( 1, -2,1,  -1.1,   -0.7,     0.2,  -0.3,    0.0,  0.0)
        term( 1, -3,0,  -7.5,   -6.8,    -0.4,  -1.1,    0.6, -0.9)
        term( 1, -4,0,   0.7,    0.7,     0.6,  -1.1,    0.0, -0.2)
        term( 1, -5,0,  51.5,  -26.0,   -32.5, -64.4,   -4.9,-12.4)
        term( 1, -5,1,  -1.2,   -2.2,    -2.7,   1.5,   -0.4,  0.3)
        term( 2,  0,0,  -3.4,  632.0,  -610.6,  -6.5, -226.8, 12.7)
        term( 2,  0,1,  -4.2,    3.8,    -4.1,  -4.5,    0.2,  0.6)
        term( 2, -1,0,   5.3,   -0.7,     0.7,   6.1,    0.2,  1.1)
        term( 2, -2,0, -76.4, -185.1,   260.2,-108.0,    1.6,  0.0)
        term( 2, -3,0,  66.7,   47.8,   -51.4,  69.8,    0.9,  0.3)
        term( 2, -3,1,   0.6,   -1.0,     1.0,   0.6,    0.0,  0.0)
        term( 2, -4,0,  17.0,    1.4,    -1.8,   9.6,    0.0, -0.1)
        term( 2, -5,0,1066.2, -518.3,    -1.3, -23.9,    1.8, -0.3)
        term( 2, -5,1, -25.4,  -40.3,    -0.9,   0.3,    0.0,  0.0)
        term( 2, -5,2,  -0.7,    0.5,     0.0,   0.0,    0.0,  0.0)
        term( 3,  0,0,  -0.1,   28.0,   -22.1,  -0.2,  -12.5,  0.7)
        term( 3, -2,0,  -5.0,  -11.5,    11.7,  -5.4,    2.1, -1.0)
        term( 3, -3,0,  16.9,   -6.4,    13.4,  26.9,   -0.5,  0.8)
        term( 3, -4,0,   7.2,  -13.3,    20.9,  10.5,    0.1, -0.1)
        term( 3, -5,0,  68.5,  134.3,  -166.9,  86.5,    7.1, 15.2)
        term( 3, -5,1,   3.5,   -2.7,     3.4,   4.3,    0.5, -0.4)
        term( 3, -6,0,   0.6,    1.0,    -0.9,   0.5,    0.0,  0.0)
        term( 3, -7,0,  -1.1,    1.7,    -0.4,  -0.2,    0.0,  0.0)
        term( 4,  0,0,   0.0,    1.4,    -1.0,   0.0,   -0.6,  0.0)
        term( 4, -2,0,  -0.3,   -0.7,     0.4,  -0.2,    0.2, -0.1)
        term( 4, -3,0,   1.1,   -0.6,     0.9,   1.2,    0.1,  0.2)
        term( 4, -4,0,   3.2,    1.7,    -4.1,   5.8,    0.2,  0.1)
        term( 4, -5,0,   6.7,    8.7,    -9.3,   8.7,   -1.1,  1.6)
        term( 4, -6,0,   1.5,   -0.3,     0.6,   2.4,    0.0,  0.0)
        term( 4, -7,0,  -1.9,    2.3,    -3.2,  -2.7,    0.0, -0.1)
        term( 4, -8,0,   0.4,   -1.8,     1.9,   0.5,    0.0,  0.0)
        term( 4, -9,0,  -0.2,   -0.5,     0.3,  -0.1,    0.0,  0.0)
        term( 4,-10,0,  -8.6,   -6.8,    -0.4,   0.1,    0.0,  0.0)
        term( 4,-10,1,  -0.5,    0.6,     0.0,   0.0,    0.0,  0.0)
        term( 5, -5,0,  -0.1,    1.5,    -2.5,  -0.8,   -0.1,  0.1)
        term( 5, -6,0,   0.1,    0.8,    -1.6,   0.1,    0.0,  0.0)
        term( 5, -9,0,  -0.5,   -0.1,     0.1,  -0.8,    0.0,  0.0)
        term( 5,-10,0,   2.5,   -2.2,     2.8,   3.1,    0.1, -0.2)
    }

    fun jupiter_pertura() { /* perturbations by Uranus */
        c[-1] = cos(m7); s[-1] = -sin(m7)
	val(a,b)=addthe(c[-1],s[-1],c[-1],s[-1]); c[-2]=a; s[-2]=b
        term( 1, -1,0,   0.4,    0.9,     0.0,   0.0,    0.0,  0.0)
        term( 1, -2,0,   0.4,    0.4,    -0.4,   0.3,    0.0,  0.0)
    }

    fun jupiter_pertsur() { /* perturbations by Saturn and Uranus */
	val phi = (2*m5-6*m6+3*m7); var x = cos(phi); var y = sin(phi)
	dl += 8.5*y-0.8*x; dr -= 0.1*x
	val(a,b)=addthe(x,y,c5[1],s5[1]); x=a; y=b
	dl += 0.4*x+0.5*y; dr += 0.5*y-0.7*x; db -= 0.1*x
    }

    fun jupiter_start(t0:Double): Triple<Double,Double,Double> {
        dl=0.0; dr=0.0; db=0.0; t=t0
        m5 = p2*frac(0.0565314+8.4302963*t); m6 = p2*frac(0.8829867+3.3947688*t)
	    m7 = p2*frac(0.3969537+1.1902586*t)
	    c5[0] = 1.0;  s5[0] = 0.0
	    c5[1] = cos(m5); s5[1] = sin(m5);  c5[-1] = c5[1]; s5[-1] = -s5[1]
	    for(i in 2 .. 5) {val(a,b)=addthe(c5[i-1],s5[i-1],c5[1],s5[1]); c5[i]=a; s5[i]=b}
	    jupiter_pertsat(); jupiter_pertura(); jupiter_pertsur()
	    val l = 360.0*frac(0.0388910 + m5/p2 + ((5025.2+0.8*t)*t+dl)/1296.0e3)
	    val r = 5.208873 + 0.000041*t  +  dr*1.0e-5
        val b = ( 227.3 - 0.3*t + db ) / 3600.0
        return Triple(l,b,r)
    }
}

val jupiter200 = Jupiter200()

/* Aufruf:
    val(l,b,r) = jupiter200.jupiter_start(t)
*/

class Saturn200 {
    var c:ArrayReal = ArrayReal(-6,1); var s:ArrayReal = ArrayReal(-6,1)
    var c6=DoubleArray(12){0.0}
    var s6=DoubleArray(12)
    var m5=0.0; var m6=0.0; var m7=0.0; var m8=0.0
    var u=0.0; var v=0.0; var dl=0.0; var dr=0.0; var db=0.0; var t=0.0

    fun term(j:Int,i:Int,it:Int, dlc:Double, dls:Double, drc:Double, drs:Double, dbc:Double, dbs:Double) {
        if(it==0) {val(a,b)=addthe(c6[j],s6[j],c[i],s[i]); u=a; v=b}
 	    else  {u *= t; v *= t;}
 	    dl += dlc*u+dls*v; dr += drc*u+drs*v; db += dbc*u+dbs*v
    }

    fun saturn_pertjup() { /* Kepler terms and perturbations by Jupiter */
        c[0] = 1.0; s[0] = 0.0; c[1] = cos(m5); s[1] = sin(m5)
 	for(i in 0 downTo -5) {val(a,b)=addthe(c[i],s[i],c[1],-s[1]); c[i-1]=a; s[i-1]=b}
        term( 0,-1,0,   12.0,   -1.4,   -13.9,    6.4,    1.2,  -1.8)
        term( 0,-2,0,    0.0,   -0.2,    -0.9,    1.0,    0.0,  -0.1)
        term( 1, 1,0,    0.9,    0.4,    -1.8,    1.9,    0.2,   0.2)
        term( 1, 0,0, -348.3,22907.7,-52915.5, -752.2,-3266.5,8314.4)
        term( 1, 0,1, -225.2, -146.2,   337.7, -521.3,   79.6,  17.4)
        term( 1, 0,2,    1.3,   -1.4,     3.2,    2.9,    0.1,  -0.4)
        term( 1,-1,0,   -1.0,  -30.7,   108.6, -815.0,   -3.6,  -9.3)
        term( 1,-2,0,   -2.0,   -2.7,    -2.1,  -11.9,   -0.1,  -0.4)
        term( 2, 1,0,    0.1,    0.2,    -1.0,    0.3,    0.0,   0.0)
        term( 2, 0,0,   44.2,  724.0, -1464.3,  -34.7, -188.7, 459.1)
        term( 2, 0,1,  -17.0,  -11.3,    18.9,  -28.6,    1.0,  -3.7)
        term( 2,-1,0,   -3.5, -426.6,  -546.5,  -26.5,   -1.6,  -2.7)
        term( 2,-1,1,    3.5,   -2.2,    -2.6,   -4.3,    0.0,   0.0)
        term( 2,-2,0,   10.5,  -30.9,  -130.5,  -52.3,   -1.9,   0.2)
        term( 2,-3,0,   -0.2,   -0.4,    -1.2,   -0.1,   -0.1,   0.0)
        term( 3, 0,0,    6.5,   30.5,   -61.1,    0.4,  -11.6,  28.1)
        term( 3, 0,1,   -1.2,   -0.7,     1.1,   -1.8,   -0.2,  -0.6)
        term( 3,-1,0,   29.0,  -40.2,    98.2,   45.3,    3.2,  -9.4)
        term( 3,-1,1,    0.6,    0.6,    -1.0,    1.3,    0.0,   0.0)
        term( 3,-2,0,  -27.0,  -21.1,   -68.5,    8.1,  -19.8,   5.4)
        term( 3,-2,1,    0.9,   -0.5,    -0.4,   -2.0,   -0.1,  -0.8)
        term( 3,-3,0,   -5.4,   -4.1,   -19.1,   26.2,   -0.1,  -0.1)
        term( 4, 0,0,    0.6,    1.4,    -3.0,   -0.2,   -0.6,   1.6)
        term( 4,-1,0,    1.5,   -2.5,    12.4,    4.7,    1.0,  -1.1)
        term( 4,-2,0, -821.9,   -9.6,   -26.0, 1873.6,  -70.5,  -4.4)
        term( 4,-2,1,    4.1,  -21.9,   -50.3,   -9.9,    0.7,  -3.0)
        term( 4,-3,0,   -2.0,   -4.7,   -19.3,    8.2,   -0.1,  -0.3)
        term( 4,-4,0,   -1.5,    1.3,     6.5,    7.3,    0.0,   0.0)
        term( 5,-2,0,-2627.6,-1277.3,   117.4, -344.1,  -13.8,  -4.3)
        term( 5,-2,1,   63.0,  -98.6,    12.7,    6.7,    0.1,  -0.2)
        term( 5,-2,2,    1.7,    1.2,    -0.2,    0.3,    0.0,   0.0)
        term( 5,-3,0,    0.4,   -3.6,   -11.3,   -1.6,    0.0,  -0.3)
        term( 5,-4,0,   -1.4,    0.3,     1.5,    6.3,   -0.1,   0.0)
        term( 5,-5,0,    0.3,    0.6,     3.0,   -1.7,    0.0,   0.0)
        term( 6,-2,0, -146.7,  -73.7,   166.4, -334.3,  -43.6, -46.7)
        term( 6,-2,1,    5.2,   -6.8,    15.1,   11.4,    1.7,  -1.0)
        term( 6,-3,0,    1.5,   -2.9,    -2.2,   -1.3,    0.1,  -0.1)
        term( 6,-4,0,   -0.7,   -0.2,    -0.7,    2.8,    0.0,   0.0)
        term( 6,-5,0,    0.0,    0.5,     2.5,   -0.1,    0.0,   0.0)
        term( 6,-6,0,    0.3,   -0.1,    -0.3,   -1.2,    0.0,   0.0)
        term( 7,-2,0,   -9.6,   -3.9,     9.6,  -18.6,   -4.7,  -5.3)
        term( 7,-2,1,    0.4,   -0.5,     1.0,    0.9,    0.3,  -0.1)
        term( 7,-3,0,    3.0,    5.3,     7.5,   -3.5,    0.0,   0.0)
        term( 7,-4,0,    0.2,    0.4,     1.6,   -1.3,    0.0,   0.0)
        term( 7,-5,0,   -0.1,    0.2,     1.0,    0.5,    0.0,   0.0)
        term( 7,-6,0,    0.2,    0.0,     0.2,   -1.0,    0.0,   0.0)
        term( 8,-2,0,   -0.7,   -0.2,     0.6,   -1.2,   -0.4,  -0.4)
        term( 8,-3,0,    0.5,    1.0,    -2.0,    1.5,    0.1,   0.2)
        term( 8,-4,0,    0.4,    1.3,     3.6,   -0.9,    0.0,  -0.1)
        term( 9,-4,0,    4.0,   -8.7,   -19.9,   -9.9,    0.2,  -0.4)
        term( 9,-4,1,    0.5,    0.3,     0.8,   -1.8,    0.0,   0.0)
        term(10,-4,0,   21.3,  -16.8,     3.3,    3.3,    0.2,  -0.2)
        term(10,-4,1,    1.0,    1.7,    -0.4,    0.4,    0.0,   0.0)
        term(11,-4,0,    1.6,   -1.3,     3.0,    3.7,    0.8,  -0.2)
    }

    fun saturn_pertura() { /* perturbations by Uranus */
        c[-1] = cos(m7); s[-1] = -sin(m7)
 	for(i in -1 downTo -4)  {val(a,b)=addthe(c[i],s[i],c[-1],s[-1]); c[i-1]=a; s[i-1]=b}
        term( 0,-1,0,    1.0,    0.7,     0.4,   -1.5,    0.1,   0.0)
        term( 0,-2,0,    0.0,   -0.4,    -1.1,    0.1,   -0.1,  -0.1)
        term( 0,-3,0,   -0.9,   -1.2,    -2.7,    2.1,   -0.5,  -0.3)
        term( 1,-1,0,    7.8,   -1.5,     2.3,   12.7,    0.0,   0.0)
        term( 1,-2,0,   -1.1,   -8.1,     5.2,   -0.3,   -0.3,  -0.3)
        term( 1,-3,0,  -16.4,  -21.0,    -2.1,    0.0,    0.4,   0.0)
        term( 2,-1,0,    0.6,   -0.1,     0.1,    1.2,    0.1,   0.0)
        term( 2,-2,0,   -4.9,  -11.7,    31.5,  -13.3,    0.0,  -0.2)
        term( 2,-3,0,   19.1,   10.0,   -22.1,   42.1,    0.1,  -1.1)
        term( 2,-4,0,    0.9,   -0.1,     0.1,    1.4,    0.0,   0.0)
        term( 3,-2,0,   -0.4,   -0.9,     1.7,   -0.8,    0.0,  -0.3)
        term( 3,-3,0,    2.3,    0.0,     1.0,    5.7,    0.3,   0.3)
        term( 3,-4,0,    0.3,   -0.7,     2.0,    0.7,    0.0,   0.0)
        term( 3,-5,0,   -0.1,   -0.4,     1.1,   -0.3,    0.0,   0.0)
    }

    fun saturn_pertnep() { /* perturbations by Neptune */
        c[-1] = cos(m8); s[-1] = -sin(m8)
	val(a,b)=addthe(c[-1],s[-1],c[-1],s[-1]); c[-2]=a; s[-2]=b
        term( 1,-1,0,   -1.3,   -1.2,     2.3,   -2.5,    0.0,   0.0)
        term( 1,-2,0,    1.0,   -0.1,     0.1,    1.4,    0.0,   0.0)
        term( 2,-2,0,    1.1,   -0.1,     0.2,    3.3,    0.0,   0.0)
    }

    fun saturn_pertjur() { /* perturbations by Jupiter and Uranus */
        val phi = (-2*m5+5*m6-3*m7); var x = cos(phi); var y = sin(phi)
	    dl -= 0.8*x+0.1*y; dr += 1.8*y-0.2*x; db += 0.3*x+0.5*y
        val(a,b)=addthe(x,y,c6[1],s6[1]); x=a; y=b
	    dl += (2.4-0.7*t)*x+(27.8-0.4*t)*y; dr += 2.1*x-0.2*y
        val(a2,b2)=addthe(x,y,c6[1],s6[1]); x=a2; y=b2
	    dl += 0.1*x+1.6*y; dr += 0.3*y-3.6*x; db += 0.6*y-0.2*x
    }

    fun saturn_start(t0:Double): Triple<Double,Double,Double> {
        dl=0.0; dr=0.0; db=0.0; t=t0
        m5 = p2*frac(0.0565314+8.4302963*t); m6 = p2*frac(0.8829867+3.3947688*t)
	    m7 = p2*frac(0.3969537+1.1902586*t); m8 = p2*frac(0.7208473+0.6068623*t)
	    c6[0] = 1.0; s6[0] = 0.0;  c6[1] = cos(m6); s6[1] = sin(m6)
	    for(i in 2 .. 11) {val(a,b)=addthe(c6[i-1],s6[i-1],c6[1],s6[1]); c6[i]=a; s6[i]=b}
	    saturn_pertjup(); saturn_pertura(); saturn_pertnep(); saturn_pertjur()
	    val l = 360.0*frac(0.2561136 + m6/p2 + ((5018.6+t*1.9)*t +dl)/1296.0e3 )
	    val r = 9.557584 - 0.000186*t  +  dr*1.0e-5
        val b = ( 175.1 - 10.2*t + db ) / 3600.0
        return Triple(l,b,r)
    }
}

val saturn200 = Saturn200()

/* Aufruf:
    val(l,b,r) = saturn200.saturn_start(t);
*/
