package ch.rolfp.mond

import android.Manifest.permission.ACCESS_FINE_LOCATION
import android.annotation.SuppressLint
import android.content.pm.PackageManager
import android.location.Location
import android.os.Bundle
import android.text.InputType
import android.widget.AdapterView
import android.widget.ArrayAdapter
import android.widget.EditText
import android.widget.ListView
import android.widget.Toast
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import ch.rolfp.mond.databinding.ActivityMainBinding
import com.google.android.gms.location.FusedLocationProviderClient
import com.google.android.gms.location.LocationServices
import com.google.android.material.floatingactionbutton.FloatingActionButton
import java.util.GregorianCalendar
import kotlin.math.asin
import kotlin.math.atan2
import kotlin.math.cos
import kotlin.math.floor
import kotlin.math.sin
import kotlin.math.tan

var wochentag:Int = -1
val wochentage: Array<String> = arrayOf("Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag","Sonntag")
val planetList:Array<String> = arrayOf("Merkur","Venus","Mars","Jupiter","Saturn")
var zeiteingabe:String = "12:00:00"
var datumeingabe:String = "25.8.2025"
var position:String = "47.374449 N  8.541042 E"
var ortsname:String = "Zürich"
var mylocation:Location = Location("gps")
var mylocOrtsname:String = ""
var hoeheUeberMeer:Double = 408.0; var luftdruck:Double = 1010.0
var distanz:Float = 0f
var jahrvorher:Int = 1; var monatvorher:Int = 1; var tagvorher:Int = 1
var aktStunde=8; var aktMinute=30; var aktSekunde=0
var auswahlMond:Int = 1; var auswahlPlanet:Int = -1
var refraktFlag:Int = 1
var miniMoonFlag:Int = 0
var exaktSunFlag:Int = 1
var hilfeFlag: Boolean=false; var toggleHilfeFlag=1
var planetAbstand:Double = 0.0
var sonneAbstand:Double = 0.0
var mondPhase = 0.0; var zuab:String = ""

class MainActivity : AppCompatActivity() {
    //val MIN_TIME_TO_REFRESH: Long = 3000L
    //val MIN_DISTANCE_TO_REFRESH: Float = 0F
    private lateinit var fusedLocationProviderClient: FusedLocationProviderClient
    lateinit var datumzeit: GregorianCalendar
    private lateinit var binding: ActivityMainBinding
    private lateinit var lvTodoList: ListView
    private lateinit var fab: FloatingActionButton
    private lateinit var fab2: FloatingActionButton
    private lateinit var fab3: FloatingActionButton
    private lateinit var fab4: FloatingActionButton
    private lateinit var fab5: FloatingActionButton
    private lateinit var shoppingItems: ArrayList<String>
    private lateinit var itemAdapter: ArrayAdapter<String>
    private var zeitzone:Int = 0 //0=UTC 1=MEZ 2=MESZ
    fun calcZeitDatum(datumzeit:GregorianCalendar) {
        val jahr = datumzeit.get(GregorianCalendar.YEAR); jahrvorher=jahr
        val monat = datumzeit.get(GregorianCalendar.MONTH)+1; monatvorher=monat
        val tag = datumzeit.get(GregorianCalendar.DAY_OF_MONTH); tagvorher=tag
        val stunde = datumzeit.get(GregorianCalendar.HOUR_OF_DAY); aktStunde=stunde
        val minute = datumzeit.get(GregorianCalendar.MINUTE); aktMinute=minute
        val sekunde = datumzeit.get(GregorianCalendar.SECOND); aktSekunde=sekunde
        wochentag = datumzeit.get(GregorianCalendar.DAY_OF_WEEK)
        zeitzone = datumzeit.get(GregorianCalendar.ZONE_OFFSET)/(60*60*1000)
        zeitzone += datumzeit.get(GregorianCalendar.DST_OFFSET)/(60*60*1000) //Sommerzeit beruecksichtigen
        //TODO: testen ob Sommerzeit richtig erkannt
        if(zeitzone>23) zeitzone=23; else if(zeitzone< -23) zeitzone= -23 //test
        zeiteingabe = sprintzeit(stunde,minute,sekunde)
        if(zeitzone==1) zeiteingabe += " MEZ"
        else if(zeitzone==2) zeiteingabe += " MESZ"
        else if(zeitzone>0) zeiteingabe += "+$zeitzone"
        else if(zeitzone<0) zeiteingabe += "$zeitzone"
        else zeiteingabe += " UTC"
        datumeingabe = sprintdatum(tag,monat,jahr)
    }

    fun erneuern() {
        // Sonnenposition berechnen:
        val resultat = berechnungSonne(position, datumeingabe, zeiteingabe, zeitzone)
        val resultatMond = berechnungMond(position, datumeingabe, zeiteingabe, zeitzone)
        val (phase,zuabStr) = calcMondPhase(); mondPhase=phase; zuab=zuabStr
        var resultPlanet:Array<String> = arrayOf("","","")

        val meter:Double = runden(hoeheUeberMeer,2)
        if(ortsname!="") shoppingItems.set(0,"$position  $meter müM\n$ortsname")
        else shoppingItems[0] = "$position  $meter müM"

        val distStr:String = sprintDistanz(distanz.toDouble())
        shoppingItems[1] = "$distStr  Distanz zu $mylocOrtsname"
        //shoppingItems[1] = "$distStr  Distanz zu $mylocOrtsname\n$testString"//test
        val wotag:String = if(wochentag>=0) wochentage[(wochentag+5)%7] else ""
        shoppingItems[2] = "$datumeingabe  $zeiteingabe  $wotag"

        if(hilfeFlag) {
            var str:String = if(exaktSunFlag==0) "Sonne: einfache Formel" else "Sonne: genaue Formel"
            str += if(miniMoonFlag==1) "\nMond: einfache Formel" else "\nMond: genaue Formel"
            str += if(refraktFlag==0) "\nohne Refraktion" else if(refraktFlag==1) "\nmit Refraktion" else "\nmit Refraktion 2.Variante"
            shoppingItems.set(3,str)
            hilfeFlag=false
        } else if(auswahlPlanet>=0) {
            val planetName = planetList[auswahlPlanet]
            resultPlanet = berechnungPlanet(position,datumeingabe,zeiteingabe,zeitzone,auswahlPlanet)
            val str:String = "$planetName Auf/Untergang"
            val abstandMioKm = runden(planetAbstand/1e9,2)
            val abstandAE = runden(planetAbstand/AE,3)
            shoppingItems.set(3,"$str\nEntfernung: $abstandMioKm Mio.km = $abstandAE AE")
            val s1:String = resultPlanet[1]; val s2:String = resultPlanet[2]; val s3:String = resultPlanet[3]
            shoppingItems.set(4,"$s1\n$s2\n$s3") //aufgang, untergang, Hoechststand
        } else if(auswahlMond!=0) {
            val str:String = if(miniMoonFlag==1) "Mond Auf/Untergang (miniMoon)" else "Mond Auf/Untergang"
            val mondAbstKm:Double = runden(mondAbstand/1000,1)
            val phase = runden(mondPhase,1)
            shoppingItems.set(3,"$str\n  Entfernung: $mondAbstKm km\n  Phase: $phase %  $zuab")
            val s1:String = resultatMond[1]; val s2:String = resultatMond[2]; val s3:String = resultatMond[3]
            shoppingItems.set(4,"$s1\n$s2\n$s3") //Mondaufgang, Monduntergang, Mond-Hoechststand
        } else {
            if(sonneAbstand!=0.0) {
                val abstandMioKm = runden(sonneAbstand/1e9,2)
                val abstandAE = runden(sonneAbstand/AE,5)
                shoppingItems.set(3,"Sonne Auf/Untergang:\nEntfernung: $abstandMioKm Mio.km = $abstandAE AE")
            } else shoppingItems.set(3,"Sonne Auf/Untergang:")
            val s1:String = resultat[1]; val s2:String = resultat[2]; val s3:String = resultat[3]
            shoppingItems.set(4,"$s1\n$s2\n$s3") //Sonnenaufgang, Sonnenuntergang, Hoechststand
        }

        if(refraktFlag==1) shoppingItems.set(5,"mit Refraktion gerechnet")
        else if(refraktFlag==2) shoppingItems.set(5,"mit Refraktion 2.Formel")
        else shoppingItems.set(5,"ohne Refraktion gerechnet")

        val maxResult:Int = 4 //maximale Anzahl anzuzeigende Resultate
        val strSun:String =  "Sonne:  "+resultat[0]
        val strMoon:String = " Mond:  "+resultatMond[0]
        val strPlanet:String = if(auswahlPlanet>=0) "\n "+planetList[auswahlPlanet]+":  "+resultPlanet[0] else ""
        val str:String = "$datumeingabe  $zeiteingabe\n$strSun\n$strMoon$strPlanet"
        if(shoppingItems.size<=5+maxResult) shoppingItems.add(str)
        else shoppingItems.set(5+maxResult,str)
        itemAdapter.notifyDataSetChanged()
    }

    fun createLocation(lat: Double, lon: Double, time: Long, accuracy:Float): Location {
        val location=Location("gps")
        location.latitude = lat
        location.longitude = lon
        if(time==0L) location.time = System.currentTimeMillis(); else location.time = time
        location.accuracy = accuracy
        return location
    }
    fun createLocation(str:String): Location {
        val p=getLatLon(str)
        return createLocation(p[0],p[1],0L,1f)
    }

    private fun requestPermission() {
        ActivityCompat.requestPermissions(this,
            arrayOf(android.Manifest.permission.ACCESS_COARSE_LOCATION, ACCESS_FINE_LOCATION),
            PERMISSION_REQUEST_ACCESS_LOCATION)
    }
    companion object{private const val PERMISSION_REQUEST_ACCESS_LOCATION=100}

    @SuppressLint("MissingPermission")
    private fun getCurrentLocation() {
        fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient(this)
        fusedLocationProviderClient.lastLocation.addOnCompleteListener(this) { task->
            val location: Location? = task.result
            if(location==null) {
                Toast.makeText(applicationContext, "Null Recieved", Toast.LENGTH_SHORT).show()
            } else {
                distanz = location.distanceTo(mylocation)
                var breite = location.latitude
                var laenge = location.longitude
                if(location.hasAltitude()) hoeheUeberMeer = location.altitude
                else hoeheUeberMeer = 0.0
                luftdruck = barometerFormel(hoeheUeberMeer)
                if(breite>=0.0 && laenge>=0.0) position = "$breite N  $laenge E"
                else if(breite<0.0 && laenge>=0.0) {breite = -breite; position = "$breite S  $laenge E"}
                else if(breite>=0.0 && laenge<0.0) {laenge = -laenge; position = "$breite N  $laenge W"}
                else {breite = -breite; laenge = -laenge; position = "$breite S  $laenge W"}
                ortsname=""
                erneuern()
            }
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        datumzeit = GregorianCalendar()
        calcZeitDatum(datumzeit)
        mylocation = createLocation(47.374449, 8.541042,0,1f)
        mylocOrtsname="Zürich"
        luftdruck = barometerFormel(hoeheUeberMeer)

        lvTodoList = findViewById(R.id.lvTodoList)
        fab = findViewById(R.id.floatingActionButton)
        fab2 = findViewById(R.id.floatingActionButton2)
        fab3 = findViewById(R.id.floatingActionButton3)
        fab4 = findViewById(R.id.floatingActionButton4)
        fab5 = findViewById(R.id.floatingActionButton5)
        shoppingItems = ArrayList()

        shoppingItems.add(position) //0 Koordinaten und Hoehe ueber Meer
        shoppingItems.add("Distanz") //1
        shoppingItems.add("$datumeingabe  $zeiteingabe") //2
        shoppingItems.add("Auswahl: Sonne oder Mond")  //3
        shoppingItems.add("Sonne/Mond-Aufgang\nSonne/Mond-Untergang\nSonne/Mond-Höchststand") //4
        shoppingItems.add("mit Refraktion gerechnet (ohne: Klicken)") //5

        itemAdapter = ArrayAdapter(this, android.R.layout.simple_list_item_1, shoppingItems)
        lvTodoList.adapter = itemAdapter

        erneuern()

        lvTodoList.onItemLongClickListener = AdapterView.OnItemLongClickListener { arg0, arg1, pos, id ->
            if(pos>=6) {
                shoppingItems.removeAt(pos)
                itemAdapter.notifyDataSetChanged()
                Toast.makeText(applicationContext, "Element gelöscht", Toast.LENGTH_SHORT).show()
            }
            true
        }

        lvTodoList.onItemClickListener = AdapterView.OnItemClickListener { arg0, arg1, pos, id ->
            if(pos==3 || pos==4) {
                if(++toggleHilfeFlag==2) {hilfeFlag=true; toggleHilfeFlag=0}
                erneuern()
            } else if(pos==2) {
                datumzeit = GregorianCalendar()
                calcZeitDatum(datumzeit)
                erneuern()
                Toast.makeText(applicationContext, "Zeit/Datum aktualisiert", Toast.LENGTH_SHORT).show()
            } else if(pos==1) {
                mylocation = createLocation(position)
                mylocOrtsname = if(ortsname=="") position else ortsname
                distanz = 0f
                erneuern()
            } else if(pos==0) {
                if (ContextCompat.checkSelfPermission(
                        this,
                        ACCESS_FINE_LOCATION
                    ) == PackageManager.PERMISSION_GRANTED
                ) {
                    //Toast.makeText(applicationContext,"Permission erhalten",Toast.LENGTH_SHORT).show()//test
                    getCurrentLocation()
                } else {
                    requestPermission() //Benutzer nach Berechtigung fragen
                }
            } else if(pos==5) {
                if(++refraktFlag >= 3) refraktFlag=0
                erneuern()
            } else false
            true
        }

        fab.setOnClickListener {
            val builder = AlertDialog.Builder(this)
            builder.setTitle("Datum eingeben")
            val input = EditText(this)
            input.hint = "$tagvorher.$monatvorher.$jahrvorher"
            input.inputType = InputType.TYPE_DATETIME_VARIATION_DATE
            builder.setView(input)
            builder.setPositiveButton("OK") { dialog, which ->
                wochentag = -1
                val eingabe:String = input.text.toString()
                if(checkDatumSyntax(eingabe)) datumeingabe=eingabe
                else Toast.makeText(applicationContext,"falsche Datumeingabe",Toast.LENGTH_SHORT).show()
                erneuern()
            }
            builder.setNegativeButton("Abbrechen") {dialog, which ->
                Toast.makeText(applicationContext,"abgebrochen",Toast.LENGTH_SHORT).show()
            }
            builder.show()
        }

        fab2.setOnClickListener {
            val builder = AlertDialog.Builder(this)
            builder.setTitle("Zeit eingeben")
            val input = EditText(this)
            input.hint = if(aktMinute<10) "$aktStunde:0$aktMinute:00" else "$aktStunde:$aktMinute:00"
            input.inputType = InputType.TYPE_CLASS_TEXT
            builder.setView(input)
            builder.setPositiveButton("OK") { dialog, which ->
                //if(input.text.isEmpty()) {zeiteingabe="00:00:00"}
                if(input.text.length < 2) {
                    datumzeit = GregorianCalendar() //aktuelle Zeit
                    calcZeitDatum(datumzeit)
                } else {
                    val eingabe:String = input.text.toString()
                    if(checkZeitSyntax(eingabe)) zeiteingabe=eingabe
                    else Toast.makeText(applicationContext,"falsche Zeiteingabe",Toast.LENGTH_SHORT).show()
                    zeitzone = getZeitzone(zeiteingabe,zeitzone)
                    Toast.makeText(applicationContext,"zeitzone=$zeitzone",Toast.LENGTH_LONG).show()
                }
                erneuern()
            }
            builder.setNegativeButton("Abbrechen") {dialog, which ->
                Toast.makeText(applicationContext,"abgebrochen",Toast.LENGTH_SHORT).show()
            }
            builder.show()
        }

        fab3.setOnClickListener {
            val builder = AlertDialog.Builder(this)
            builder.setTitle("Pos: 47.365 N  8.622 E")
            val input = EditText(this)
            input.hint = "47.365 N  8.622 E"
            input.inputType = InputType.TYPE_CLASS_TEXT
            builder.setView(input)
            builder.setPositiveButton("OK") { dialog, which ->
                if(input.text.isNotEmpty()) {
                    val posneu:String = input.text.toString()
                    if(checkPositionSyntax(posneu)) {
                        position=posneu.uppercase()
                        ortsname=""
                        val p=getLatLon(position); val lat=p[0]; val lon=p[1]
                        val location:Location = createLocation(lat,lon,0,1f)
                        distanz = location.distanceTo(mylocation)
                    } else {
                        val ort:Ort? = inListeSuchen(posneu)
                        if(ort!=null) {
                            val lat=ort.lat; val lon=ort.lon
                            val location:Location = createLocation(lat,lon,0,1f)
                            position = sprintLocation(lat,lon)
                            var name = ort.ort
                            if(ort.land!=null && ort.land!=ort.ort) name += " ("+ort.land+")"
                            ortsname = name
                            hoeheUeberMeer = ort.alt.toDouble()
                            distanz = location.distanceTo(mylocation)
                        } else Toast.makeText(applicationContext,"Ort \"$posneu\" nicht gefunden",Toast.LENGTH_LONG).show()
                    }
                }
                erneuern()
            }
            builder.setNegativeButton("Abbrechen") {dialog, which ->
                Toast.makeText(applicationContext,"abgebrochen",Toast.LENGTH_SHORT).show()
            }
            builder.show()
        }

        fab4.setOnClickListener {
            val builder = AlertDialog.Builder(this)
            builder.setTitle("Auf/Untergang berechnen für")
            val input = EditText(this)
            input.inputType = InputType.TYPE_TEXT_FLAG_MULTI_LINE
            input.hint = "Merkur Venus Mars Jupiter Saturn"
            builder.setView(input)
            builder.setPositiveButton("Sonne") { dialog, which ->
                auswahlMond=0; auswahlPlanet= -1
                erneuern()
            }
            builder.setNegativeButton("Mond") {dialog, which ->
                auswahlMond=1; auswahlPlanet= -1
                erneuern()
            }
            builder.setNeutralButton("Planet") {dialog, which ->
                val str:String = input.text.toString()
                val(planet,nr) = planetAuswahl(str)
                auswahlPlanet=nr
                if(planet!="") {
                    Toast.makeText(applicationContext,"Daten für $planet werden berechnet",Toast.LENGTH_LONG).show()
                    erneuern()
                } else Toast.makeText(applicationContext,"Planet '$str' nicht gefunden",Toast.LENGTH_SHORT).show()
            }
            builder.show()
        }

        fab5.setOnClickListener {
            val builder = AlertDialog.Builder(this)
            builder.setTitle("Optionen setzen für")
            val input = EditText(this)
            input.inputType = InputType.TYPE_TEXT_FLAG_MULTI_LINE
            input.hint = "aus/ein oder 0/1"
            builder.setView(input)
            builder.setPositiveButton("Refraktion") { dialog, which ->
                var str = input.text.toString(); var ok=true
                if(str.isNotEmpty()) {
                    if (str[0] == 'e' || str[0] == 'E' || str[0] == '1') refraktFlag = 1
                    else if (str[0] == 'a' || str[0] == 'A' || str[0] == '0') refraktFlag = 0
                    else if (str[0].isDigit()) refraktFlag = str[0]-'0'
                    else if(str[0]=='h' || str[0]=='H' || str[0]=='?') {hilfeFlag=true; toggleHilfeFlag=0}
                    else ok=false
                } else if(refraktFlag==0) refraktFlag=1 else refraktFlag=0
                if(hilfeFlag) str="Hilfe ein"
                else if(ok) {
                    str= if(refraktFlag==1) "mit Refraktion" else if(refraktFlag==0) "ohne Refraktion" else "mit Refraktion 2.Formel"
                } else {str="falsche Eingabe"; hilfeFlag=true}
                Toast.makeText(this, str, Toast.LENGTH_SHORT).show()
                erneuern()
            }
            builder.setNegativeButton("Genaue Sonne") { dialog, which ->
                var str = input.text.toString(); var ok=true
                if(str.isNotEmpty()) {
                    if (str[0] == 'e' || str[0] == 'E' || str[0] == '1') exaktSunFlag = 1
                    else if (str[0] == 'a' || str[0] == 'A' || str[0] == '0') exaktSunFlag = 0
                    else if(str[0]=='h' || str[0]=='H' || str[0]=='?') {hilfeFlag=true; toggleHilfeFlag=0}
                    else ok=false
                } else exaktSunFlag = 1-exaktSunFlag
                if(hilfeFlag) str="Hilfe ein"
                else if(ok) {str= if(exaktSunFlag==0) "Sonne: einfache Formel" else "Sonne: genaue Formel"}
                else {str="falsche Eingabe"; hilfeFlag=true}
                Toast.makeText(this, str, Toast.LENGTH_SHORT).show()
                erneuern()
            }
            builder.setNeutralButton("Genauer Mond") { dialog, which ->
                var str = input.text.toString(); var ok=true
                if(str.isNotEmpty()) {
                    if (str[0] == 'e' || str[0] == 'E' || str[0] == '1') miniMoonFlag = 0
                    else if (str[0] == 'a' || str[0] == 'A' || str[0] == '0') miniMoonFlag = 1
                    else if(str[0]=='h' || str[0]=='H' || str[0]=='?') {hilfeFlag=true; toggleHilfeFlag=0}
                    else ok=false
                } else miniMoonFlag = 1-miniMoonFlag
                if(hilfeFlag) str="Hilfe ein"
                else if(ok) {str= if(miniMoonFlag==1) "Mond: einfache Formel" else "Mond: genaue Formel"}
                else {str="falsche Eingabe"; hilfeFlag=true}
                Toast.makeText(this, str, Toast.LENGTH_SHORT).show()
                erneuern()
            }
            builder.show()
        }

    }
}

fun vergleich(str1:String,str2:String,n:Int): Boolean { //Erste n Zeichen von 2 Texten vergleichen
    if(str1.length<n || str2.length<n) return false
    val s1 = str1.trim().lowercase().substring(0,n)
    val s2 = str2.trim().lowercase().substring(0,n)
    return s1==s2
}

var nrPlanetVorher:Int = -1
fun planetAuswahl(str:String): Pair<String, Int> {
    if(str.isEmpty()) {
        if(nrPlanetVorher>=0) return Pair(planetList[nrPlanetVorher],nrPlanetVorher)
        else return Pair("",-1)
    }
    var planet:String = ""; var nr:Int = -1; auswahlPlanet=nr
    var n:Int = 2
    if(str.length<2) {
        n=1; if(str[0]=='m' || str[0]=='M') return Pair("",-1)
    } 
    for(i in 0..4) {
        if(vergleich(str,planetList[i],n)) {planet=planetList[i]; nr=i; break}
    }
    if(nr>=0) nrPlanetVorher=nr
    return Pair(planet,nr)
}
/*
fun calcDistance(loc1:Location, loc2:Location):Double {
    val lat1:Double = loc1.latitude; val lon1:Double = loc1.longitude
    val lat2:Double = loc2.latitude; val lon2:Double = loc2.longitude
    val R:Double = 6371.0*1000 // Erdradius in Meter
    //val R:Double = 6374.6*1000 // Erdradius in Meter//test
    //val R:Double = 6367.5*1000 // Erdradius in Meter//test
    val t1 = sin((lat2-lat1)*GRAD/2)
    val t2 = sin((lon2-lon1)*GRAD/2)
    val theta = t1*t1 + cos(lat1*GRAD)*cos(lat2*GRAD) * t2*t2
    val dist = R * 2 * atan2(sqrt(theta), sqrt(1.0-theta))
    return dist
}
*/

fun checkPositionSyntax(position:String): Boolean {
    if(position.isEmpty() || position.length < 4) return false
    val posu = position.uppercase()
    if(posu[0] >= '0' && posu[0] <= '9') {
        if(posu.contains('N') && posu.contains('E')) return true
        if(posu.contains('N') && posu.contains('W')) return true
        if(posu.contains('S') && posu.contains('E')) return true
        if(posu.contains('S') && posu.contains('W')) return true
    }
    return false
}

fun checkDatumSyntax(str:String): Boolean {
    if(str.isEmpty() || !(str[0]>='0' && str[0]<='9')) return false
    if(str.contains(':')) return false
    return true
}

fun checkZeitSyntax(str:String): Boolean {
    if(str.isEmpty() || !(str[0]>='0' && str[0]<='9')) return false
    if(str.contains('.') || str.contains('-')) return false
    return true
}

fun getZeitzone(zeit:String, zeitzone:Int):Int {
    var zone:Int = zeitzone
    val str = zeit.uppercase()
    if(str.contains('M'))
      {if(str.contains('S')) zone = 2; else zone = 1}
    else if(str.contains('U')) zone = 0
    return zone
}

fun berechnungSonne(position:String, datum:String, zeit:String, zeitzone:Int): Array<String> {
    var haz:hoeheAzimut
    var tag:Int; var monat:Int; var jahr: Int
    var stunde:Int; var min:Int; var sek: Int
    var z=mysscanf(datum); tag=z[0]; monat=z[1]; jahr=z[2]
    if(jahr<100 || monat>12 || monat<1 ) {
        if(jahr==0) jahr=jahrvorher; else if(jahr<100) jahr+=2000
        if(monat>12) monat=12; else if(monat<1) monat=monatvorher
        datumeingabe=sprintdatum(tag,monat,jahr)
    }
    if(monat>12) monat=12; else if(monat<1) monat=1
    z = mysscanf(zeit); stunde=z[0]; min=z[1]; sek=z[2]
    if(stunde>23) stunde=23; if(min>59) min=59; if(sek>59) sek=59
    aktStunde=stunde; aktMinute=min; aktSekunde=sek
    zeiteingabe = sprintzeit(stunde,min,sek)
    if(zeitzone==1) zeiteingabe += " MEZ"
    else if(zeitzone==2) zeiteingabe += " MESZ"
    else if(zeitzone>0) zeiteingabe += "+$zeitzone"
    else if(zeitzone<0) zeiteingabe += "$zeitzone"
    else zeiteingabe += " UTC"
    val lat:Double //Geografische Breite
    val lon:Double //Geografische Laenge
    val p=getLatLon(position); lat=p[0]; lon=p[1]
    getPosFlag=true
    haz = sonnenpositionBerechnen(jahr,monat,tag,stunde,min,sek,lat,lon,zeitzone,refraktFlag)
    getPosFlag=false
    val hoehe=haz.hoehe; val azimut=haz.azimut
    val hoeheGrad = runden(hoehe/GRAD,2)
    val azimutGrad = runden(azimut/GRAD,2)
    //val resultat="Hoehe=$hoeheGrad Grad  Azimut=$azimutGrad Grad"
    val resultat = "Höhe: $hoeheGrad° Azimut: $azimutGrad°"
    var maxhoehe:Double = -90*GRAD
    stunde=0; min=0; sek=0
    var maxstu:Int=0; var maxmin:Int=0; var maxsek:Int=0
    var aufgang:String="--"; var untergang:String="--"
    val r1:Double = -sunMoonRadius*GRAD
    var startflag:Int=1; var hoehevorher:Double=0.0
    while(stunde<24) {
        haz = sonnenpositionBerechnen(jahr,monat,tag,stunde,min,sek,lat,lon,zeitzone,refraktFlag)
        val hoehe=haz.hoehe //val azimut=haz.azimut;
        if(startflag==1) {startflag=0}
        else if(hoehe>=r1 && hoehevorher<r1) aufgang=sprintzeit(stunde,min,sek)
        else if(hoehe<r1 && hoehevorher>=r1) untergang=sprintzeit(stunde,min,sek)
        hoehevorher=hoehe
        if(hoehe>maxhoehe) {maxhoehe=hoehe; maxstu=stunde; maxmin=min; maxsek=sek}
        sek+=5
        if(sek>=60) {sek=0; if(++min==60) {min=0; ++stunde}}
    }
    val maxhoeheGrad = runden(maxhoehe/GRAD,2)
    val hoechststand = "Höchststand: $maxhoeheGrad° um " + sprintzeit(maxstu,maxmin,maxsek)
    return arrayOf(resultat,"Sonnenaufgang: $aufgang","Sonnenuntergang: $untergang",hoechststand)
}

fun getLatLon(eingabe:String): Array<Double> {
    // Regex: alle Zeichen ausser Ziffern, Punkt, Minus, N,S,E,W durch Leerzeichen ersetzen
    val str:String = eingabe.replace(Regex("[^\\d.\\-NSEW]+")," ").trimStart()
    var lat:Double; var lon:Double = 0.0
    if(str.isEmpty() || !str[0].isDigit()) return arrayOf(0.0,0.0)
    var parts: List<String>
    if(str.contains('N')) {
        parts = str.split("N")
        lat = parts[0].toDouble()
    } else if(str.contains('S')) {
        parts = str.split("S")
        lat = -parts[0].toDouble()
    } else return arrayOf(0.0,0.0)
    if(parts[1].isEmpty()) return arrayOf(lat,0.0)
    if (parts[1].contains('E')) {
        val parts2 = parts[1].split("E")
        if(parts2[0].isNotEmpty()) lon = parts2[0].toDouble()
    } else if (parts[1].contains('W')) {
        val parts2 = parts[1].split("W")
        if(parts2[0].isNotEmpty()) lon = -parts2[0].toDouble()
    }
    return arrayOf(lat,lon)
}

fun runden(x:Double, n:Int):Double { //x auf n Nachkommastellen runden
 if(x<0.0) return -runden(-x,n)
 var z:Int=1
 var k:Int=n
 while(k>0) {z*=10; k--}
 return floor(x*z+0.5)/z
}

fun sprintzeit(h:Int, m:Int, s:Int):String {
    var str:String = if(h<10) "0" else ""
    str+="$h:"; if(m<10) str+="0"
    str+="$m:"; if(s<10) str+="0"
    str+="$s"
    return str
}

fun sprintDistanz(dist:Double):String {
    val meter:Double = runden(dist, 2)
    if(meter<1000) return "$meter m"
    var km:Double = meter/1000
    if(km>100) km = runden(km,1)
    else if(km>10) km = runden(km,2)
    else km = runden(km,3)
    return "$km km"
}

fun sprintdatum(tag:Int, mon:Int, year:Int):String {
    val str:String
    str = "$tag.$mon.$year"
    return str
}

fun sprintLocation(lat:Double, lon:Double):String {
    var NS:Char = 'N'; var EW: Char = 'E'
    val lat1:Double; if(lat<0) {NS='S'; lat1 = -lat} else lat1=lat
    val lon1:Double; if(lon<0) {EW='W'; lon1 = -lon} else lon1=lon
    return "$lat1 $NS  $lon1 $EW"
}

fun mysscanf(eingabe:String):Array<Int> {
    val str:String = eingabe.trimStart()
    if(str.isEmpty()) return arrayOf(0,0,0)
    //val parts = str.split(':','.',' ','U','M')
    val parts = str.replace(Regex("[^\\d.\\-:]+")," ").split(':','.',' ')
    if(parts.isEmpty() || parts[0].isEmpty()) return arrayOf(0,0,0)
    val p1:Int = parts[0].toInt()
    var p2:Int; if(parts.size>1 && !parts[1].isEmpty()) p2 = parts[1].toInt(); else p2=0
    var p3:Int; if(parts.size>2 && !parts[2].isEmpty()) p3 = parts[2].toInt(); else p3=0
    return arrayOf(p1,p2,p3)
}

data class hoeheAzimut(val hoehe:Double, val azimut:Double)

/************** Formel zum Sonnenposition berechnen *******************/
// JD-Formel: http://www.rolfp.ch/pfister/formelsammlung.html#mjd
// weitere Formeln: https://de.wikipedia.org/wiki/Sonnenstand

fun sonnenpositionBerechnen(jahr1:Int, monat1:Int, tag1:Int, //Datum und
			     stunde1:Int, minute:Int, sekunde:Int, //Zeit in UT oder MEZ oder MESZ
			     lat:Double, lon:Double, //Geographische Koordinaten in Grad
			     zeitzone:Int, //0=UT, 1=MEZ, 2=MESZ
			     refraktflag:Int //1=Refraktion beruecksichtigen
			     ):hoeheAzimut //Rueckgabewerte in Rad
{
    var jahr:Int; var monat:Int; var tag:Int; var stunde:Int
    if(zeitzone!=0) {
        //Umrechnung der Zeit in UT
        val zeit1:jahrMonatTagStunde = jahrMonatTagStunde(jahr1, monat1, tag1, stunde1)
        val zeit:jahrMonatTagStunde = umrechnungZonenzeitUT(zeit1, zeitzone)
        jahr=zeit.jahr; monat=zeit.monat; tag=zeit.tag; stunde=zeit.stunde
    }
    else {jahr=jahr1; monat=monat1; tag=tag1; stunde=stunde1}
    val mjd:Double = calcMJD(jahr,monat,tag,stunde,minute,sekunde)
    val n:Double = mjd - 51544.5 //in MJD ist 2400000.5 schon subrahiert
    val tt = n/36525.0
    if(getPosFlag || exaktSunFlag!=0) {
        calcSunPos(tt) //Berechnung mit sun200 fuer Abstand zur Sonne und xyz-Werte
    }

    var lambda:Double; var hoehe:Double; var azimut: Double
    if(exaktSunFlag==0) {
        // einfache Formel fuer Sonnenberechnung:
        var L: Double = 280.460 * GRAD + 0.9856474 * GRAD * n //mittlere Laenge
        var g: Double = 357.528 * GRAD + 0.9856003 * GRAD * n //mittlere Anomalie
        //eventuell noch L und g in den Bereich von 0 bis 2Pi bringen:
        while (L >= ZWEIPI) {
            L -= ZWEIPI
        }
        while (g >= ZWEIPI) {
            g -= ZWEIPI
        }
        lambda = L + 1.915 * GRAD * sin(g) + 0.01997 * GRAD * sin(2 * g) //ekliptikale Laenge
        val epsilon: Double = 23.439 * GRAD - 0.0000004 * GRAD * n //Schiefe der Ekliptik
        val alfa: Double = atan2(cos(epsilon) * sin(lambda), cos(lambda)) //Rektaszension
        val delta: Double = asin(sin(epsilon) * sin(lambda)) //Deklination
        val T0: Double = (calcMJD(jahr, monat, tag, 0, 0, 0) - 51544.5) / 36525.0
        val T: Double = stunde + minute / 60.0 + sekunde / 3600.0
        var thetahg: Double = 6.697376 + 2400.05134 * T0 + 1.002738 * T
        while (thetahg >= 24.0) {
            thetahg -= 24.0
        }
        val thetag: Double = thetahg * 15 * GRAD //mittlere Sternzeit
        val theta: Double = thetag + lon * GRAD //Stundenwinkel des Fruehlingspunkts
        val tau: Double = theta - alfa //Stundenwinkel der Sonne
        val phi: Double = lat * GRAD //Geographische Breite
        azimut = atan2(sin(tau), cos(tau) * sin(phi) - tan(delta) * cos(phi))
        hoehe = asin(cos(delta) * cos(tau) * cos(phi) + sin(delta) * sin(phi))
    } else {
        // exakte Formel fuer Sonnenberechnung:
        // grosse Berechnungen schon mit calcSunPos() in sun200.kt gemacht
        val(x2,y2,z2) = eclequ(tt,sunPosx,sunPosy,sunPosz)
        val(x,y,z) = nutequ(tt,x2,y2,z2)
        val(rr,dec,ra) = polar(x,y,z)
        lambda=ra
        val(ho,az) = hoeheAzimutBerechnen(mjd,ra,dec,rr,lat,lon)
        hoehe=ho*GRAD; azimut=az*GRAD
        if(azimut>180.0*GRAD) azimut -= 360.0*GRAD //Azimut in Bereich -180 bis +180 Grad bringen
    }
    //Refraktion beruecksichtigen:
    if(refraktflag!=0 && hoehe<45*GRAD && hoehe > -45*GRAD) {
        val R:Double = calcRefraction(hoehe,refraktflag)
        hoehe += R*WINKELMINUTE
    }
    if(getPosFlag) sunRa = lambda/GRAD
    return hoeheAzimut(hoehe,azimut)
}

fun berechnungMond(position:String, datum:String, zeit:String, zeitzone:Int): Array<String> {
    var tag:Int; var monat:Int; var jahr: Int
    var stunde:Int; var min:Int; var sek: Int
    var z=mysscanf(datum); tag=z[0]; monat=z[1]; jahr=z[2]
    if(jahr<100 || monat>12 || monat<1 ) {
        if(jahr==0) jahr=jahrvorher; else if(jahr<100) jahr+=2000
        if(monat>12) monat=12; else if(monat<1) monat=monatvorher
        datumeingabe=sprintdatum(tag,monat,jahr)
    }
    if(monat>12) monat=12; else if(monat<1) monat=1

    z = mysscanf(zeit); stunde=z[0]; min=z[1]; sek=z[2]
    if(stunde>23) stunde=23; if(min>59) min=59; if(sek>59) sek=59
    val lat:Double //Geografische Breite
    val lon:Double //Geografische Laenge
    val p=getLatLon(position); lat=p[0]; lon=p[1]
    getPosFlag=true
    val(hoehe,azimut,R) = mondpositionBerechnen(jahr,monat,tag,stunde,min,sek,lat,lon,zeitzone,refraktFlag)
    getPosFlag=false
    val hoeheGrad = runden(hoehe/GRAD,2)
    val azimutGrad = runden(azimut/GRAD,2)
    var refractString:String = ""//test
    if(refraktFlag!=0 && hoehe<=45*GRAD && hoehe >= -45*GRAD) {
        val R2:Int = runden(R, 0).toInt()//test
        refractString = "R=$R2'" //test
    }
    //val resultat = "Höhe: $hoeheGrad° Azimut: $azimutGrad°"
    val resultat = "Höhe: $hoeheGrad° Azimut: $azimutGrad° $refractString"//test
    var maxhoehe:Double = -90*GRAD
    stunde=0; min=0; sek=0
    var maxstu:Int=0; var maxmin:Int=0; var maxsek:Int=0
    var aufgang:String="--"; var untergang:String="--"; var hoechststand:String
    val r1:Double = -sunMoonRadius*GRAD
    var startflag:Int=1; var hoehevorher:Double=0.0
    while(stunde<24) {
        val(hoehe,azimut) = mondpositionBerechnen(jahr,monat,tag,stunde,min,sek,lat,lon,zeitzone,refraktFlag)
        if(startflag==1) {startflag=0}
        else if(hoehe>=r1 && hoehevorher<r1) aufgang=sprintzeit(stunde,min,sek)
        else if(hoehe<r1 && hoehevorher>=r1) untergang=sprintzeit(stunde,min,sek)
        hoehevorher=hoehe
        if(hoehe>maxhoehe) {maxhoehe=hoehe; maxstu=stunde; maxmin=min; maxsek=sek}
        if((hoehe>2*GRAD || hoehe < -2*GRAD) &&
            ((azimut>2*GRAD && azimut<178*GRAD) || (azimut < -2*GRAD && azimut > -178*GRAD))) {
            sek=0; if(++min==60) {min=0; ++stunde}
        } else {
            sek += 5; if(sek>=60) { sek=0; if(++min==60) {min=0; ++stunde} }
        }
    }
    val maxhoeheGrad = runden(maxhoehe/GRAD,2)
    hoechststand = "Höchststand: $maxhoeheGrad° um " + sprintzeit(maxstu,maxmin,maxsek)
    return arrayOf(resultat,"Mondaufgang: $aufgang","Monduntergang: $untergang",hoechststand)
}

fun berechnungPlanet(position:String, datum:String, zeit:String, zeitzone:Int, planetNr:Int): Array<String> {
    var tag:Int; var monat:Int; var jahr: Int
    var stunde:Int; var min:Int; var sek: Int
    var z=mysscanf(datum); tag=z[0]; monat=z[1]; jahr=z[2]
    if(jahr<100 || monat>12 || monat<1 ) {
        if(jahr==0) jahr=jahrvorher; else if(jahr<100) jahr+=2000
        if(monat>12) monat=12; else if(monat<1) monat=monatvorher
        datumeingabe=sprintdatum(tag,monat,jahr)
    }
    if(monat>12) monat=12; else if(monat<1) monat=1

    z = mysscanf(zeit); stunde=z[0]; min=z[1]; sek=z[2]
    if(stunde>23) stunde=23; if(min>59) min=59; if(sek>59) sek=59
    val lat:Double; val lon:Double //Geografische Breite und Laenge
    val p=getLatLon(position); lat=p[0]; lon=p[1]
    val(hoehe,azimut,rr,rs) = planetpositionBerechnen(jahr,monat,tag,stunde,min,sek,lat,lon,zeitzone,refraktFlag,planetNr)
    val hoeheGrad = runden(hoehe,2)
    val azimutGrad = runden(azimut,2)
    planetAbstand = rr*AE

    val R2:Int = runden(planetR, 0).toInt()//test
    val refractString:String = if(R2==0) "" else "R=$R2'" //test
    //val resultat = "Höhe: $hoeheGrad° Azimut: $azimutGrad°"
    val resultat = "Höhe: $hoeheGrad° Azimut: $azimutGrad° $refractString"//test
    var maxhoehe:Double = -90*GRAD
    stunde=0; min=0; sek=0
    var maxstu:Int=0; var maxmin:Int=0; var maxsek:Int=0
    var aufgang:String="--"; var untergang:String="--"; var hoechststand:String
    val r1:Double = 0.0 //Planetenradius ist vernachlaessigbar im Gegensatz zu Mond u. Sonne
    var startflag:Int=1; var hoehevorher:Double=0.0
    while(stunde<24) {
        val(hoehe,azimut) = planetpositionBerechnen(jahr,monat,tag,stunde,min,sek,lat,lon,zeitzone,refraktFlag,planetNr)
        if(startflag==1) {startflag=0}
        else if(hoehe>=r1 && hoehevorher<r1) aufgang=sprintzeit(stunde,min,sek)
        else if(hoehe<r1 && hoehevorher>=r1) untergang=sprintzeit(stunde,min,sek)
        hoehevorher=hoehe
        if(hoehe>maxhoehe) {maxhoehe=hoehe; maxstu=stunde; maxmin=min; maxsek=sek}
        if((hoehe>2*GRAD || hoehe < -2*GRAD) &&
            ((azimut>2*GRAD && azimut<178*GRAD) || (azimut < -2*GRAD && azimut > -178*GRAD))) {
            sek=0; if(++min==60) {min=0; ++stunde}
        } else {
            sek += 5; if(sek>=60) { sek=0; if(++min==60) {min=0; ++stunde} }
        }
    }
    val maxhoeheGrad = runden(maxhoehe,2)
    hoechststand = "Höchststand: $maxhoeheGrad° um " + sprintzeit(maxstu,maxmin,maxsek)
    val planetName:String = planetList[planetNr]
    return arrayOf(resultat,"$planetName-aufgang: $aufgang","$planetName-untergang: $untergang",hoechststand)
}
