package ch.rolfp.minirechner

import android.annotation.SuppressLint
import kotlin.math.floor

fun runden(x:Double, n:Int):Double { //x auf n Nachkommastellen runden
    if(x<0.0) return -runden(-x,n)
    var z:Int=1
    var k:Int=n
    while(k>0) {z*=10; k--}
    return floor(x*z+0.5)/z
}

fun abrunden(x:Double, n:Int):Double { //x auf n Nachkommastellen abrunden
    if(x<0.0) return -abrunden(-x,n)
    var z:Int=1
    var k:Int=n
    while(k>0) {z*=10; k--}
    return floor(x*z)/z
}

fun mysscanf(eingabe:String): Triple<Int,Int,Double> {
    val str:String = eingabe.trimStart()
    if(str.isEmpty()) return Triple(0,0,0.0)
    val parts = str.split(':')
    if(parts.isEmpty() || parts[0].isEmpty()) return Triple(0,0,0.0)
    val p1:Int = parts[0].toInt()
    val p2:Int = if(parts.size>1 && parts[1].isNotEmpty()) parts[1].toInt() else 0
    val p3:Double = if(parts.size>2 && parts[2].isNotEmpty()) parts[2].toDouble() else 0.0
    return Triple(p1,p2,p3)
}

fun zeitToDouble(str:String):Double {
    val(h,m,s) = mysscanf(str)
    return h.toDouble()+m/60.0+s/3600.0
}
fun hexToDouble(str:String):Double {
    var x=0.0; var s=str.replace(Regex("\\s"), "")
    if(s.isEmpty()) return 0.0
    if(s.length>=2 && s[0]=='0' && s[1]=='x') s=s.drop(2)
    var c:Char='0'
    while(s.isNotEmpty()) {
        c = s[0]; s=s.drop(1)
        if(c=='.' || c=='*') break
        val z:Int = if(c>='0' && c<='9') c-'0' else if(c>='A' && c<='F') c-'A'+10 else if(c>='a' && c<='f') c-'a'+10 else -1
        if(z>=0) x = x*16 + z
    }
    if(s.isNotEmpty()) {
        if(c=='.') {
            var y=1.0/16.0
            while(s.isNotEmpty()) {
                c = s[0]; s=s.drop(1)
                if(c=='*') break
                val z:Int = if(c>='0' && c<='9') c-'0' else if(c>='A' && c<='F') c-'A'+10 else if(c>='a' && c<='f') c-'a'+10 else -1
                if(z== -1) break
                x += z*y; y /= 16.0
            }
        }
        if (c == '*') { }//TODO
    }
    return x
}
fun longToHex(n:Long):String {
    var x=n
    var str:String = ""
    if(x<0) {str="-"; x = -x}
    if(x>=0x10000) {
        val z=x/0x10000
        str += longToHex(z)+"'"
        x -= z*0x10000; var t:Long = 0x1000
        for(i in 1..4) {
            val digit = x/t
            val c: Char = if (digit < 10) '0' + digit.toInt() else 'A' - 10 + digit.toInt()
            str += "$c"
            x -= digit*t
            t /= 16
        }
    } else str += String.format("%X",x)
    return str
}

@SuppressLint("DefaultLocale")
fun myFormat(form:String, x:Double):String {
    if(form.isEmpty()) return "Error: empty form"
    if(form[0]=='%') return String.format(form,x)
    val vorz:String = if(x<0) "-" else ""
    val x1 = if(x<0) -x else x
    if(form[0]=='X') {
        // Hexadezimaldarstellung
        var str:String = vorz+"0x"
        val xi=x1.toLong()
        //str += String.format("0x%X",xi) //TODO: Vierergruppen: z.B. 0xFFFF'FFFF
        str += longToHex(xi)
        var x2:Double = x1-xi
        if(x2!=0.0) {
            var k = str.length; k -= k/5
            val n = 12 + 2 - k //TODO: 12 = Anzahl anzuzeigende Stellen
            if(n>=1) str+="."
            for(i in 1..n) {
                x2 *= 16.0
                val digit = x2.toInt()
                val c: Char = if (digit < 10) '0' + digit else 'A' + (digit - 10)
                str += "$c"
                x2 -= digit
                if (x2 == 0.0) break
            }
        }
        return str
    } else {
        // Zeit:Min:Sek oder Grad/Winkelminuten/Winkelsekunden
        val h: Int = x1.toInt()
        val m: Int = ((x1 - h) * 60).toInt()
        val sd: Double = runden(((x1 - h) * 60 - m) * 60, 2)
        val si: Int = sd.toInt()
        if (form[0] == 'Z') {
            if (si.toDouble() == sd) return vorz + String.format("%d:%02d:%02d", h, m, si)
            return vorz + String.format("%d:%02d:%05.2f", h, m, sd)
        } else if (form[0] == 'G') {
            if (si.toDouble() == sd) return vorz + String.format("%d°%02d'%02d''", h, m, si)
            return vorz + String.format("%d°%02d'%05.2f''", h, m, sd)
        }
    }
    return "Error: $form"
}
var tastenListe: Array<String> = arrayOf(
    "0", "+/-", ".", ":", "Enter",
    "1", "2", "3", "+", "-",
    "4", "5", "6", "*", "/",
    "7", "8", "9", "Exp", "Cor",
    "y^x", "Sqrt", "x^2", "Pop", "x↔y",
    "sin", "cos", "tan", "ln", "log",
    "Fn", "STO", "RCL", "Up", "Dwn",
    "Fn2", "Pgm", "F1", "F2", "F3",
    )
var tastenListeFn: Array<String> = arrayOf(
    "0", "+/-", ".", ":", "Enter",
    "1", "2", "3", "+", "-",
    "4", "5", "6", "*", "/",
    "7", "8", "9", "Exp", "Cor",
    "DEG", "RAD", "x^2", "Pop", "x↔y",
    "asin", "acos", "atan", "e^x", "10^x",
    "Fn", "Pi", "x!", "Up", "Dwn",
    "Fn2", "Pgm", "F1", "F2", "F3",
)
var tastenListeFn2: Array<String> = arrayOf(
    "0", "+/-", ".", ":", "Enter",
    "1", "2", "3", "+", "-",
    "4", "5", "6", "*", "/",
    "7", "8", "9", "Exp", "Cor",
    "A", "1/x", "x^2", "Pop", "x↔y",
    "B", "C", "D", "E", "F",
    "HEX", "STO", "RCL", "Up", "Dwn",
    "Fn2", "Pgm", "F1", "F2", "F3",
)
var tastenListeFn3: Array<String> = arrayOf(
    "0", "+/-", ".", ":", "Enter",
    "1", "2", "3", "+", "-",
    "4", "5", "6", "*", "/",
    "7", "8", "9", "CMP", "Cor",
    "BEQ", "BLT", "BLE", "SUB", "x↔y",
    "BNE", "BGT", "BGE", "BR", "LBL",
    "RET", "STO", "RCL", "Up", "Dwn",
    "END", "Fn3", "F1", "F2", "F3",
)
fun getNr(str:String):Int {
    if(str=="Ret" || str=="RET") return codRet
    if(str=="End" || str=="END") return codEnd
    if(str=="Nop" || str=="NOP") return codNop
    if(str=="LBL") return codLBL
    var zeile=1; var spalte=1
    for(s in tastenListe) {
        if(s==str) return zeile*10+spalte
        if(++spalte==6) {spalte=1; zeile++}
    }
    zeile=1; spalte=1
    for(s in tastenListeFn) {
        if(s==str) return zeile*10+spalte+100
        if(++spalte==6) {spalte=1; zeile++}
    }
    zeile=1; spalte=1
    for(s in tastenListeFn2) {
        if(s==str) return zeile*10+spalte+200
        if(++spalte==6) {spalte=1; zeile++}
    }
    zeile=1; spalte=1
    for(s in tastenListeFn3) {
        if(s==str) return zeile*10+spalte+300
        if(++spalte==6) {spalte=1; zeile++}
    }
    return 0
}

fun getBef(cod:Int):String {
    if(cod==codRet) return "Ret"
    if(cod==codEnd) return "End"
    if(cod==codNop) return "Nop"
    if(cod==codLBL) return "LBL"
    for(i in 0..8*5-1) {
        val str = tastenListe[i];
        val nr = getNr(str)
        if (nr == cod) return str
    }
    for(i in 0..8*5-1) {
        val str = tastenListeFn[i];
        val nr = getNr(str)
        if (nr == cod) return str
    }
    for(i in 0..8*5-1) {
        val str = tastenListeFn2[i]; val nr = getNr(str)
        if(nr==cod) return str
    }
    for(i in 0..8*5-1) {
        val str = tastenListeFn3[i]; val nr = getNr(str)
        if(nr==cod) return str
    }
    return "?"
}
