package ch.rolfp.minirechner
import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.cardview.widget.CardView
import androidx.recyclerview.widget.RecyclerView
public interface SelectListener {
    fun onItemClicked(item:String)
}
class ArecyclerViewAdapter(val context:Context, val list:List<String>, val listener:SelectListener) : RecyclerView.Adapter<ArecyclerViewAdapter.MyViewHolder>() {
    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ArecyclerViewAdapter.MyViewHolder {
        val inflater: LayoutInflater = LayoutInflater.from(context)
        val view:View = inflater.inflate(R.layout.recycler_view_row,parent,false)
        return ArecyclerViewAdapter.MyViewHolder(view)
    }
    override fun onBindViewHolder(holder: ArecyclerViewAdapter.MyViewHolder, position: Int) {
        holder.tvName.text=list[position]
        holder.cardView.setOnClickListener {
            listener.onItemClicked(list[position])
        }
    }
    override fun getItemCount():Int {return list.size}
    public class MyViewHolder(itemView:View) : RecyclerView.ViewHolder(itemView) {
        var cardView: CardView = itemView.findViewById(R.id.cardview)
        var tvName: TextView = itemView.findViewById(R.id.tv1)
    }
}
